/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.packet.packetfilter;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.onlab.util.Tools;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketInClassifier;
import org.onosproject.net.packet.PacketInFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPacketInFilter
implements PacketInFilter {
    private AtomicInteger currentCounter = new AtomicInteger(0);
    private AtomicInteger windowBlockCounter = new AtomicInteger(0);
    private AtomicInteger overFlowCounter = new AtomicInteger(0);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private int pps = 100;
    private int winSize = 500;
    private int guardTime = 10;
    private int winThres = 10;
    private int maxCounter;
    private ScheduledExecutorService timerExecutor;
    private ScheduledExecutorService windowUnblockExecutor;
    private boolean windowBlocked;
    private boolean packetProcessingBlocked;
    private String counterName;
    private final PacketInClassifier classifier;

    public DefaultPacketInFilter(int pps, int winSize, int guardTime, int winThres, String counterName, PacketInClassifier classifier) {
        this.pps = pps;
        this.winSize = winSize;
        this.guardTime = guardTime;
        this.winThres = winThres;
        this.counterName = counterName;
        this.classifier = classifier;
        this.maxCounter = pps * winSize / 1000;
        this.timerExecutor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"packet/packetfilter", (String)"packet-filter-timer-%d", (Logger)this.log));
        this.windowUnblockExecutor = Executors.newScheduledThreadPool(1, Tools.groupedThreads((String)"packet/packetfilter", (String)"packet-filter-unblocker-%d", (Logger)this.log));
        this.timerExecutor.scheduleAtFixedRate(new ClearWindowBlock(), 0L, winSize, TimeUnit.MILLISECONDS);
        this.windowBlocked = false;
        this.packetProcessingBlocked = false;
    }

    @Override
    public PacketInFilter.FilterAction preProcess(PacketContext packet) {
        this.maxCounter = this.pps * this.winSize / 1000;
        if (this.maxCounter == 0 && this.pps != 0) {
            this.log.trace("{}: maxCounter set to 1 as was coming as 0", (Object)this.counterName);
            this.maxCounter = 1;
        }
        if (!this.classifier.match(packet)) {
            return PacketInFilter.FilterAction.FILTER_INVALID;
        }
        if (this.pps == 0 && this.maxCounter == 0) {
            this.log.trace("{}: Filter is disabled", (Object)this.counterName);
            return PacketInFilter.FilterAction.FILTER_DISABLED;
        }
        this.log.trace("{}: Preprocess called", (Object)this.counterName);
        if (this.packetProcessingBlocked) {
            this.log.trace("{}: Packet processing is blocked for sometime", (Object)this.counterName);
            return PacketInFilter.FilterAction.PACKET_BLOCKED;
        }
        if (this.windowBlocked) {
            this.log.trace("{}: Packet processing is blocked for the window number: {}", (Object)this.counterName, (Object)this.windowBlockCounter.get());
            return PacketInFilter.FilterAction.WINDOW_BLOCKED;
        }
        if (this.currentCounter.getAndIncrement() < this.maxCounter) {
            this.log.trace("{}: Packet is picked for processing with currentCounter: {} and maxCounter: {}", new Object[]{this.counterName, this.currentCounter.get(), this.maxCounter});
            return PacketInFilter.FilterAction.PACKET_ALLOW;
        }
        this.windowBlocked = true;
        if (this.windowBlockCounter.incrementAndGet() > this.winThres) {
            this.log.trace("{}: Packet processing blocked as current window crossed threshold currentWindowNumber: {} maxWindowNumber: {}", new Object[]{this.counterName, this.windowBlockCounter.get(), this.winThres});
            this.packetProcessingBlocked = true;
            this.windowUnblockExecutor.schedule(new ClearPacketProcessingBlock(), (long)this.guardTime, TimeUnit.SECONDS);
        } else {
            this.log.trace("{}: WindowBlockCounter: {} winThres: {}", new Object[]{this.counterName, this.windowBlockCounter.get(), this.winThres});
        }
        this.currentCounter.decrementAndGet();
        if (this.overFlowCounter.incrementAndGet() < 0) {
            this.overFlowCounter.set(0);
        }
        this.log.trace("{}: Overflow counter is: {}", (Object)this.counterName, (Object)this.overFlowCounter.get());
        return PacketInFilter.FilterAction.PACKET_DENY;
    }

    @Override
    public String name() {
        return this.counterName;
    }

    @Override
    public int pendingPackets() {
        return this.currentCounter.get();
    }

    @Override
    public int droppedPackets() {
        return this.overFlowCounter.get();
    }

    @Override
    public void setPps(int pps) {
        this.pps = pps;
    }

    @Override
    public void setWinSize(int winSize) {
        this.winSize = winSize;
    }

    @Override
    public void setGuardTime(int guardTime) {
        this.guardTime = guardTime;
    }

    @Override
    public void setWinThres(int winThres) {
        this.winThres = winThres;
    }

    @Override
    public void stop() {
        this.timerExecutor.shutdown();
        this.windowUnblockExecutor.shutdown();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPacketInFilter that = (DefaultPacketInFilter)o;
        return this.pps == that.pps && this.winSize == that.winSize && this.guardTime == that.guardTime && this.winThres == that.winThres && this.counterName.equals(that.counterName) && this.classifier.equals(that.classifier);
    }

    public int hashCode() {
        return Objects.hash(this.pps, this.winSize, this.guardTime, this.winThres, this.counterName, this.classifier);
    }

    private final class ClearPacketProcessingBlock
    implements Runnable {
        private ClearPacketProcessingBlock() {
        }

        @Override
        public void run() {
            DefaultPacketInFilter.this.log.trace("{}: All blocks cleared in ClearPacketProcessingBlock", (Object)DefaultPacketInFilter.this.counterName);
            DefaultPacketInFilter.this.currentCounter.set(0);
            DefaultPacketInFilter.this.windowBlocked = false;
            DefaultPacketInFilter.this.packetProcessingBlocked = false;
            DefaultPacketInFilter.this.windowBlockCounter.set(0);
        }
    }

    private final class ClearWindowBlock
    implements Runnable {
        private ClearWindowBlock() {
        }

        @Override
        public void run() {
            if (!DefaultPacketInFilter.this.windowBlocked) {
                DefaultPacketInFilter.this.log.trace("{}: WindowBlockCounter is reset as there was no blocking in current window with current windowBlockCounter: {}", (Object)DefaultPacketInFilter.this.counterName, (Object)DefaultPacketInFilter.this.windowBlockCounter.get());
                DefaultPacketInFilter.this.windowBlockCounter.set(0);
            }
            if (DefaultPacketInFilter.this.currentCounter.get() == 0) {
                DefaultPacketInFilter.this.log.trace("{}: No packets in the current window so not doing anything in ClearWindowBlock", (Object)DefaultPacketInFilter.this.counterName);
                return;
            }
            DefaultPacketInFilter.this.log.trace("{}: Current counter and windowBlocked is reset in ClearWindowBlock", (Object)DefaultPacketInFilter.this.counterName);
            DefaultPacketInFilter.this.currentCounter.set(0);
            DefaultPacketInFilter.this.windowBlocked = false;
        }
    }
}

