/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiCloneSessionEntry;
import org.onosproject.net.pi.runtime.PiPreEntryHandle;
import org.onosproject.net.pi.runtime.PiPreEntryType;

@Beta
public final class PiCloneSessionEntryHandle
extends PiPreEntryHandle {
    private final int sessionId;

    private PiCloneSessionEntryHandle(DeviceId deviceId, int sessionId) {
        super(deviceId);
        this.sessionId = sessionId;
    }

    public static PiCloneSessionEntryHandle of(DeviceId deviceId, int sessionId) {
        return new PiCloneSessionEntryHandle(deviceId, sessionId);
    }

    public static PiCloneSessionEntryHandle of(DeviceId deviceId, PiCloneSessionEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        return new PiCloneSessionEntryHandle(deviceId, entry.sessionId());
    }

    public int sessionId() {
        return this.sessionId;
    }

    @Override
    public PiPreEntryType preEntryType() {
        return PiPreEntryType.CLONE_SESSION;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.sessionId});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiCloneSessionEntryHandle that = (PiCloneSessionEntryHandle)o;
        return Objects.equal((Object)this.deviceId(), (Object)that.deviceId()) && Objects.equal((Object)this.sessionId, (Object)that.sessionId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("sessionId", this.sessionId).toString();
    }
}

