/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import java.util.concurrent.TimeUnit;
import org.onosproject.net.flow.DefaultFlowRule;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.StoredFlowEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowEntry
extends DefaultFlowRule
implements StoredFlowEntry {
    private static final Logger log = LoggerFactory.getLogger(DefaultFlowEntry.class);
    private static final long DEFAULT_LAST_SEEN = -1L;
    private static final int DEFAULT_ERR_CODE = -1;
    private static final int DEFAULT_ERR_TYPE = -1;
    private long life;
    private long packets;
    private long bytes;
    private FlowEntry.FlowEntryState state;
    private FlowEntry.FlowLiveType liveType;
    private long lastSeen = -1L;
    private final int errType;
    private final int errCode;

    public DefaultFlowEntry(FlowRule rule, FlowEntry.FlowEntryState state, long life, TimeUnit lifeTimeUnit, long packets, long bytes) {
        super(rule);
        this.state = state;
        this.life = lifeTimeUnit.toNanos(life);
        this.liveType = FlowEntry.FlowLiveType.UNKNOWN;
        this.packets = packets;
        this.bytes = bytes;
        this.errCode = -1;
        this.errType = -1;
        this.lastSeen = System.currentTimeMillis();
    }

    public DefaultFlowEntry(FlowRule rule, FlowEntry.FlowEntryState state, long life, TimeUnit lifeTimeUnit, FlowEntry.FlowLiveType liveType, long packets, long bytes) {
        this(rule, state, life, lifeTimeUnit, packets, bytes);
        this.liveType = liveType;
    }

    public DefaultFlowEntry(FlowRule rule, FlowEntry.FlowEntryState state, long lifeSecs, FlowEntry.FlowLiveType liveType, long packets, long bytes) {
        this(rule, state, lifeSecs, TimeUnit.SECONDS, packets, bytes);
        this.liveType = liveType;
    }

    public DefaultFlowEntry(FlowRule rule, FlowEntry.FlowEntryState state, long lifeSecs, long packets, long bytes) {
        this(rule, state, lifeSecs, TimeUnit.SECONDS, packets, bytes);
    }

    public DefaultFlowEntry(FlowRule rule) {
        this(rule, FlowEntry.FlowEntryState.PENDING_ADD, 0L, 0L, 0L);
    }

    public DefaultFlowEntry(FlowRule rule, FlowEntry.FlowEntryState state) {
        this(rule, state, 0L, 0L, 0L);
    }

    public DefaultFlowEntry(FlowRule rule, int errType, int errCode) {
        super(rule);
        this.state = FlowEntry.FlowEntryState.FAILED;
        this.errType = errType;
        this.errCode = errCode;
        this.lastSeen = System.currentTimeMillis();
    }

    @Override
    public long life() {
        return this.life(TimeUnit.SECONDS);
    }

    @Override
    public long life(TimeUnit timeUnit) {
        return timeUnit.convert(this.life, TimeUnit.NANOSECONDS);
    }

    @Override
    public FlowEntry.FlowLiveType liveType() {
        return this.liveType;
    }

    @Override
    public long packets() {
        return this.packets;
    }

    @Override
    public long bytes() {
        return this.bytes;
    }

    @Override
    public FlowEntry.FlowEntryState state() {
        return this.state;
    }

    @Override
    public long lastSeen() {
        return this.lastSeen;
    }

    @Override
    public void setLastSeen() {
        this.lastSeen = System.currentTimeMillis();
    }

    @Override
    public void setState(FlowEntry.FlowEntryState newState) {
        this.state = newState;
    }

    @Override
    public void setLife(long life) {
        this.setLife(life, TimeUnit.SECONDS);
    }

    @Override
    public void setLife(long life, TimeUnit timeUnit) {
        this.life = timeUnit.toNanos(life);
    }

    @Override
    public void setLiveType(FlowEntry.FlowLiveType liveType) {
        this.liveType = liveType;
    }

    @Override
    public void setPackets(long packets) {
        this.packets = packets;
    }

    @Override
    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public int errType() {
        return this.errType;
    }

    @Override
    public int errCode() {
        return this.errCode;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rule", (Object)super.toString()).add("state", (Object)this.state).add("life", this.life).add("liveType", (Object)this.liveType).add("packets", this.packets).add("bytes", this.bytes).add("errCode", this.errCode).add("errType", this.errType).add("lastSeen", this.lastSeen).toString();
    }
}

