/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterFeaturesFlag;
import org.onosproject.net.meter.MeterScope;

public final class DefaultMeterFeatures
implements MeterFeatures {
    private DeviceId deviceId;
    private long startIndex;
    private long endIndex;
    private Set<Band.Type> bandTypes;
    private Set<Meter.Unit> units;
    private boolean burst;
    private boolean stats;
    private short maxBands;
    private short maxColor;
    private Set<MeterFeaturesFlag> features;
    private MeterScope scope;

    private DefaultMeterFeatures(DeviceId did, long startIndex, long endIndex, Set<Band.Type> bandTypes, Set<Meter.Unit> units, boolean burst, boolean stats, short maxBands, short maxColor, Set<MeterFeaturesFlag> flag, MeterScope scope) {
        this.deviceId = did;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.bandTypes = bandTypes;
        this.burst = burst;
        this.stats = stats;
        this.units = units;
        this.maxBands = maxBands;
        this.maxColor = maxColor;
        this.features = flag;
        this.scope = scope;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public long maxMeter() {
        long maxMeter = 0L;
        if (this.startIndex != -1L && this.endIndex != -1L) {
            maxMeter = this.endIndex - this.startIndex + 1L;
        }
        return maxMeter;
    }

    @Override
    public long startIndex() {
        return this.startIndex;
    }

    @Override
    public long endIndex() {
        return this.endIndex;
    }

    @Override
    public Set<Band.Type> bandTypes() {
        return this.bandTypes;
    }

    @Override
    public Set<Meter.Unit> unitTypes() {
        return this.units;
    }

    @Override
    public boolean isBurstSupported() {
        return this.burst;
    }

    @Override
    public boolean isStatsSupported() {
        return this.stats;
    }

    @Override
    public short maxBands() {
        return this.maxBands;
    }

    @Override
    public short maxColor() {
        return this.maxColor;
    }

    @Override
    public Set<MeterFeaturesFlag> features() {
        return this.features;
    }

    @Override
    public MeterScope scope() {
        return this.scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MeterFeatures noMeterFeatures(DeviceId deviceId) {
        return DefaultMeterFeatures.builder().forDevice(deviceId).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("deviceId", (Object)this.deviceId()).add("startIndex", this.startIndex()).add("endIndex", this.endIndex()).add("maxBands", (int)this.maxBands()).add("maxColor", (int)this.maxColor()).add("bands", this.bandTypes()).add("burst", this.isBurstSupported()).add("stats", this.isStatsSupported()).add("units", this.unitTypes()).add("scope", (Object)this.scope()).toString();
    }

    public static final class Builder
    implements MeterFeatures.Builder {
        private DeviceId did;
        private long mmeter = 0L;
        private long starti = -1L;
        private long endi = -1L;
        private short mbands = 0;
        private short mcolors = 0;
        private Set<Band.Type> bandTypes = new HashSet<Band.Type>();
        private Set<Meter.Unit> units1 = new HashSet<Meter.Unit>();
        private boolean burst = false;
        private boolean stats = false;
        private Set<MeterFeaturesFlag> features = Sets.newHashSet();
        private MeterScope mscope = MeterScope.globalScope();

        @Override
        public MeterFeatures.Builder forDevice(DeviceId deviceId) {
            this.did = deviceId;
            return this;
        }

        @Override
        public MeterFeatures.Builder withMaxMeters(long maxMeter) {
            this.mmeter = maxMeter;
            return this;
        }

        @Override
        public MeterFeatures.Builder withStartIndex(long startIndex) {
            this.starti = startIndex;
            return this;
        }

        @Override
        public MeterFeatures.Builder withEndIndex(long endIndex) {
            this.endi = endIndex;
            return this;
        }

        @Override
        public MeterFeatures.Builder withMaxBands(short maxBands) {
            this.mbands = maxBands;
            return this;
        }

        @Override
        public MeterFeatures.Builder withMaxColors(short maxColors) {
            this.mcolors = maxColors;
            return this;
        }

        @Override
        public MeterFeatures.Builder withBandTypes(Set<Band.Type> types) {
            this.bandTypes = types;
            return this;
        }

        @Override
        public MeterFeatures.Builder withUnits(Set<Meter.Unit> units) {
            this.units1 = units;
            return this;
        }

        @Override
        public MeterFeatures.Builder hasBurst(boolean hasBurst) {
            this.burst = hasBurst;
            return this;
        }

        @Override
        public MeterFeatures.Builder hasStats(boolean hasStats) {
            this.stats = hasStats;
            return this;
        }

        @Override
        public MeterFeatures.Builder withFeatures(Set<MeterFeaturesFlag> featureFlags) {
            this.features = featureFlags;
            return this;
        }

        @Override
        public MeterFeatures.Builder withScope(MeterScope scope) {
            this.mscope = scope;
            return this;
        }

        @Override
        public MeterFeatures build() {
            if (this.mmeter != 0L && this.starti == -1L && this.endi == -1L) {
                this.starti = this.mscope.isGlobal() ? 1L : 0L;
                long l = this.endi = this.mscope.isGlobal() ? this.mmeter : this.mmeter - 1L;
            }
            if (this.starti <= -1L || this.endi <= -1L) {
                this.starti = -1L;
                this.endi = -1L;
            }
            Preconditions.checkNotNull((Object)this.did, (Object)"Must specify a device");
            Preconditions.checkArgument((this.starti <= this.endi ? 1 : 0) != 0, (Object)"Start index must be less than or equal to end index");
            return new DefaultMeterFeatures(this.did, this.starti, this.endi, this.bandTypes, this.units1, this.burst, this.stats, this.mbands, this.mcolors, this.features, this.mscope);
        }
    }
}

