/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.runtime.PiActionProfileGroup;
import org.onosproject.net.pi.runtime.PiActionProfileGroupId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;

@Beta
public final class PiActionProfileGroupHandle
extends PiHandle {
    private final PiActionProfileId actionProfileId;
    private final PiActionProfileGroupId groupId;

    private PiActionProfileGroupHandle(DeviceId deviceId, PiActionProfileGroup group) {
        super(deviceId);
        this.actionProfileId = group.actionProfile();
        this.groupId = group.id();
    }

    public static PiActionProfileGroupHandle of(DeviceId deviceId, PiActionProfileGroup group) {
        return new PiActionProfileGroupHandle(deviceId, group);
    }

    public PiActionProfileId actionProfile() {
        return this.actionProfileId;
    }

    public PiActionProfileGroupId groupId() {
        return this.groupId;
    }

    @Override
    public PiEntityType entityType() {
        return PiEntityType.ACTION_PROFILE_GROUP;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deviceId(), this.actionProfileId, this.groupId});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiActionProfileGroupHandle that = (PiActionProfileGroupHandle)o;
        return Objects.equal((Object)this.deviceId(), (Object)that.deviceId()) && Objects.equal((Object)((Object)this.actionProfileId), (Object)((Object)that.actionProfileId)) && Objects.equal((Object)this.groupId, (Object)that.groupId);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId()).add("actionProfile", (Object)this.actionProfileId).add("groupId", (Object)this.groupId).toString();
    }
}

