/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.pi.model.PiMeterId;
import org.onosproject.net.pi.model.PiMeterType;
import org.onosproject.net.pi.runtime.PiTableEntry;

@Beta
public final class PiMeterCellId
implements MeterCellId {
    private final PiMeterId meterId;
    private final PiMeterType meterType;
    private final long index;
    private final PiTableEntry tableEntry;

    private PiMeterCellId(PiMeterId meterId, PiMeterType meterType, long index, PiTableEntry tableEntry) {
        this.meterId = meterId;
        this.meterType = meterType;
        this.index = index;
        this.tableEntry = tableEntry;
    }

    public PiMeterId meterId() {
        return this.meterId;
    }

    public PiMeterType meterType() {
        return this.meterType;
    }

    public long index() {
        return this.index;
    }

    public PiTableEntry tableEntry() {
        return this.tableEntry;
    }

    @Override
    public MeterCellId.MeterCellType type() {
        return MeterCellId.MeterCellType.PIPELINE_INDEPENDENT;
    }

    public static PiMeterCellId ofDirect(PiTableEntry tableEntry) {
        Preconditions.checkNotNull((Object)tableEntry);
        return new PiMeterCellId(null, PiMeterType.DIRECT, -1L, tableEntry);
    }

    public static PiMeterCellId ofIndirect(PiMeterId meterId, long index) {
        Preconditions.checkNotNull((Object)((Object)meterId));
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"Index must be a positive number");
        return new PiMeterCellId(meterId, PiMeterType.INDIRECT, index, null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiMeterCellId other = (PiMeterCellId)obj;
        return Objects.equal((Object)((Object)this.meterId), (Object)((Object)other.meterId)) && Objects.equal((Object)((Object)this.meterType), (Object)((Object)other.meterType)) && Objects.equal((Object)this.index, (Object)other.index) && Objects.equal((Object)this.tableEntry, (Object)other.tableEntry);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.meterId, this.meterType, this.index, this.tableEntry});
    }

    public String toString() {
        return this.meterType == PiMeterType.DIRECT ? this.tableEntry.toString() : this.meterId.toString() + ":" + String.valueOf(this.index);
    }
}

