/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;

public class ClusterEventTest {
    private final NodeId node1 = new NodeId("1");
    private final NodeId node2 = new NodeId("2");
    private final IpAddress ip1 = IpAddress.valueOf((String)"10.0.0.1");
    private final IpAddress ip2 = IpAddress.valueOf((String)"10.0.0.2");
    private final ControllerNode cNode1 = new DefaultControllerNode(this.node1, this.ip1);
    private final ControllerNode cNode2 = new DefaultControllerNode(this.node2, this.ip2);
    private final ClusterEvent event1 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, this.cNode1);
    private final ClusterEvent event2 = new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, this.cNode1);
    private final ClusterEvent event3 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, this.cNode1);
    private final ClusterEvent event4 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode1);
    private final ClusterEvent event5 = new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, this.cNode1);
    private final ClusterEvent event6 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, this.cNode2);
    private final long time = System.currentTimeMillis();
    private final ClusterEvent event7 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode2, this.time);
    private final ClusterEvent sameAsEvent7 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode2, this.time);
    private final ClusterEvent event8 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, this.cNode2, ClusterEvent.InstanceType.ONOS);
    private final ClusterEvent event9 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, this.cNode2, ClusterEvent.InstanceType.STORAGE);
    private final ClusterEvent event10 = new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, this.cNode2, ClusterEvent.InstanceType.ONOS);
    private final ClusterEvent event11 = new ClusterEvent(ClusterEvent.Type.INSTANCE_REMOVED, this.cNode2, ClusterEvent.InstanceType.STORAGE);
    private final ClusterEvent event12 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, this.cNode1, ClusterEvent.InstanceType.ONOS);
    private final ClusterEvent event13 = new ClusterEvent(ClusterEvent.Type.INSTANCE_ACTIVATED, this.cNode1, ClusterEvent.InstanceType.STORAGE);
    private final ClusterEvent event14 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode1, ClusterEvent.InstanceType.ONOS);
    private final ClusterEvent event15 = new ClusterEvent(ClusterEvent.Type.INSTANCE_READY, this.cNode1, ClusterEvent.InstanceType.STORAGE);
    private final ClusterEvent event16 = new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, this.cNode1, ClusterEvent.InstanceType.ONOS);
    private final ClusterEvent event17 = new ClusterEvent(ClusterEvent.Type.INSTANCE_DEACTIVATED, this.cNode1, ClusterEvent.InstanceType.STORAGE);

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.event1}).addEqualityGroup(new Object[]{this.event2}).addEqualityGroup(new Object[]{this.event3}).addEqualityGroup(new Object[]{this.event4}).addEqualityGroup(new Object[]{this.event5}).addEqualityGroup(new Object[]{this.event6}).addEqualityGroup(new Object[]{this.event7, this.sameAsEvent7}).addEqualityGroup(new Object[]{this.event8}).addEqualityGroup(new Object[]{this.event9}).addEqualityGroup(new Object[]{this.event10}).addEqualityGroup(new Object[]{this.event11}).addEqualityGroup(new Object[]{this.event12}).addEqualityGroup(new Object[]{this.event13}).addEqualityGroup(new Object[]{this.event14}).addEqualityGroup(new Object[]{this.event15}).addEqualityGroup(new Object[]{this.event16}).addEqualityGroup(new Object[]{this.event17}).testEquals();
    }

    @Test
    public void checkConstruction() {
        Assert.assertThat((Object)((ClusterEvent.Type)this.event1.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_ADDED));
        Assert.assertThat((Object)((ControllerNode)this.event1.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event1.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.UNKNOWN));
        Assert.assertThat((Object)this.event7.time(), (Matcher)Matchers.is((Object)this.time));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event7.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_READY));
        Assert.assertThat((Object)((ControllerNode)this.event7.subject()), (Matcher)Matchers.is((Object)this.cNode2));
        Assert.assertThat((Object)this.event7.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.UNKNOWN));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event8.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_ADDED));
        Assert.assertThat((Object)((ControllerNode)this.event8.subject()), (Matcher)Matchers.is((Object)this.cNode2));
        Assert.assertThat((Object)this.event8.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.ONOS));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event9.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_ADDED));
        Assert.assertThat((Object)((ControllerNode)this.event9.subject()), (Matcher)Matchers.is((Object)this.cNode2));
        Assert.assertThat((Object)this.event9.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.STORAGE));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event10.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_REMOVED));
        Assert.assertThat((Object)((ControllerNode)this.event10.subject()), (Matcher)Matchers.is((Object)this.cNode2));
        Assert.assertThat((Object)this.event10.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.ONOS));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event11.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_REMOVED));
        Assert.assertThat((Object)((ControllerNode)this.event11.subject()), (Matcher)Matchers.is((Object)this.cNode2));
        Assert.assertThat((Object)this.event11.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.STORAGE));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event12.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_ACTIVATED));
        Assert.assertThat((Object)((ControllerNode)this.event12.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event12.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.ONOS));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event13.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_ACTIVATED));
        Assert.assertThat((Object)((ControllerNode)this.event13.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event13.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.STORAGE));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event14.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_READY));
        Assert.assertThat((Object)((ControllerNode)this.event14.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event14.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.ONOS));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event15.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_READY));
        Assert.assertThat((Object)((ControllerNode)this.event15.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event15.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.STORAGE));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event16.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_DEACTIVATED));
        Assert.assertThat((Object)((ControllerNode)this.event16.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event16.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.ONOS));
        Assert.assertThat((Object)((ClusterEvent.Type)this.event17.type()), (Matcher)Matchers.is((Object)ClusterEvent.Type.INSTANCE_DEACTIVATED));
        Assert.assertThat((Object)((ControllerNode)this.event17.subject()), (Matcher)Matchers.is((Object)this.cNode1));
        Assert.assertThat((Object)this.event17.instanceType(), (Matcher)Matchers.is((Object)ClusterEvent.InstanceType.STORAGE));
    }
}

