/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.intent.ConnectivityIntentTest;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.PointToPointIntent;

public class PointToPointIntentTest
extends ConnectivityIntentTest {
    @Test
    public void checkImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(PointToPointIntent.class);
    }

    @Test
    public void basics() {
        PointToPointIntent intent = this.createOne();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.filteredIngressPoint().connectPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.filteredEgressPoint().connectPoint());
        intent = this.createWithResourceGroup();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)P1, (Object)intent.filteredIngressPoint().connectPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)P2, (Object)intent.filteredEgressPoint().connectPoint());
        Assert.assertEquals((String)"incorrect resource group", (Object)RESOURCE_GROUP, (Object)intent.resourceGroup());
    }

    @Test
    public void filtered() {
        PointToPointIntent intent = this.createOneFiltered();
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)FP1, (Object)intent.filteredIngressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)FP2, (Object)intent.filteredEgressPoint());
    }

    @Test
    public void suggestedPath() {
        LinkedList<Link> suggestedPath = new LinkedList<Link>();
        suggestedPath.add((Link)new IntentTestsMocks.FakeLink(FP1.connectPoint(), FP2.connectPoint()));
        PointToPointIntent intent = this.createWithSuggestedPath(suggestedPath);
        Assert.assertEquals((String)"incorrect id", (Object)APPID, (Object)intent.appId());
        Assert.assertEquals((String)"incorrect match", (Object)MATCH, (Object)intent.selector());
        Assert.assertEquals((String)"incorrect ingress", (Object)FP1, (Object)intent.filteredIngressPoint());
        Assert.assertEquals((String)"incorrect egress", (Object)FP2, (Object)intent.filteredEgressPoint());
        Assert.assertEquals((String)"incorrect suggested path", suggestedPath, (Object)intent.suggestedPath());
    }

    @Test
    public void failSuggestedPath() {
        LinkedList<Link> suggestedPath = new LinkedList<Link>();
        try {
            suggestedPath.add((Link)new IntentTestsMocks.FakeLink(FP3.connectPoint(), FP2.connectPoint()));
            this.createWithSuggestedPath(suggestedPath);
            Assert.fail((String)"Point to Point intent building with incompatible suggested path not throw exception.");
        }
        catch (IllegalArgumentException exception) {
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"Suggested path not compatible"));
        }
    }

    protected PointToPointIntent createOne() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P1)).filteredEgressPoint(new FilteredConnectPoint(P2)).build();
    }

    protected PointToPointIntent createWithResourceGroup() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P1)).filteredEgressPoint(new FilteredConnectPoint(P2)).resourceGroup(RESOURCE_GROUP).build();
    }

    protected PointToPointIntent createAnother() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(new FilteredConnectPoint(P2)).filteredEgressPoint(new FilteredConnectPoint(P1)).build();
    }

    protected PointToPointIntent createOneFiltered() {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(FP1).filteredEgressPoint(FP2).build();
    }

    protected PointToPointIntent createWithSuggestedPath(List<Link> suggestedPath) {
        return PointToPointIntent.builder().appId(APPID).selector(MATCH).treatment(NOP).filteredIngressPoint(FP1).filteredEgressPoint(FP2).suggestedPath(suggestedPath).build();
    }
}

