/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.TierConstraint;
import org.onosproject.net.provider.ProviderId;

public class TierConstraintTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:3");
    private static final DeviceId DID4 = DeviceId.deviceId((String)"of:4");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PN2 = PortNumber.portNumber((long)2L);
    private static final PortNumber PN3 = PortNumber.portNumber((long)3L);
    private static final PortNumber PN4 = PortNumber.portNumber((long)4L);
    private static final PortNumber PN5 = PortNumber.portNumber((long)5L);
    private static final PortNumber PN6 = PortNumber.portNumber((long)6L);
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private static final String TIER1 = "1";
    private static final String TIER2 = "2";
    private static final String TIER3 = "3";
    private ResourceContext resourceContext;
    private Path path12;
    private Path path13;
    private Path path23;
    private DefaultLink link1;
    private DefaultLink link2;
    private DefaultLink link3;

    @Before
    public void setUp() {
        this.resourceContext = (ResourceContext)EasyMock.createMock(ResourceContext.class);
        DefaultAnnotations annotations1 = DefaultAnnotations.builder().set("tier", TIER1).build();
        DefaultAnnotations annotations2 = DefaultAnnotations.builder().set("tier", TIER2).build();
        DefaultAnnotations annotations3 = DefaultAnnotations.builder().set("tier", TIER3).build();
        this.link1 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID1, PN1)).dst(DefaultLinkTest.cp((ElementId)DID2, PN2)).type(Link.Type.DIRECT).annotations((Annotations)annotations1).build();
        this.link2 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID2, PN3)).dst(DefaultLinkTest.cp((ElementId)DID3, PN4)).type(Link.Type.DIRECT).annotations((Annotations)annotations2).build();
        this.link3 = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID2, PN5)).dst(DefaultLinkTest.cp((ElementId)DID4, PN6)).type(Link.Type.DIRECT).annotations((Annotations)annotations3).build();
        this.path12 = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link1, this.link2), (Weight)ScalarWeight.toWeight((double)10.0), new Annotations[0]);
        this.path13 = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link1, this.link3), (Weight)ScalarWeight.toWeight((double)10.0), new Annotations[0]);
        this.path23 = new DefaultPath(PROVIDER_ID, Arrays.asList(this.link2, this.link3), (Weight)ScalarWeight.toWeight((double)10.0), new Annotations[0]);
    }

    @Test
    public void testSatisfyIncludedTiers() {
        TierConstraint constraint12 = new TierConstraint(true, new Integer[]{1, 2});
        Assert.assertThat((Object)constraint12.validate(this.path12, this.resourceContext), (Matcher)Matchers.is((Object)true));
        TierConstraint constraint13 = new TierConstraint(true, new Integer[]{1, 3});
        Assert.assertThat((Object)constraint13.validate(this.path13, this.resourceContext), (Matcher)Matchers.is((Object)true));
        TierConstraint constraint23 = new TierConstraint(true, new Integer[]{2, 3});
        Assert.assertThat((Object)constraint23.validate(this.path23, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testNotSatisfyIncludedTiers() {
        TierConstraint constraint12 = new TierConstraint(true, new Integer[]{1, 2});
        Assert.assertThat((Object)constraint12.validate(this.path13, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint12.validate(this.path23, this.resourceContext), (Matcher)Matchers.is((Object)false));
        TierConstraint constraint13 = new TierConstraint(true, new Integer[]{1, 3});
        Assert.assertThat((Object)constraint13.validate(this.path12, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint13.validate(this.path23, this.resourceContext), (Matcher)Matchers.is((Object)false));
        TierConstraint constraint23 = new TierConstraint(true, new Integer[]{2, 3});
        Assert.assertThat((Object)constraint23.validate(this.path12, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint23.validate(this.path13, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSatisfyExcludedTiers() {
        TierConstraint constraint12 = new TierConstraint(false, new Integer[]{1});
        Assert.assertThat((Object)constraint12.validate(this.path23, this.resourceContext), (Matcher)Matchers.is((Object)true));
        TierConstraint constraint13 = new TierConstraint(false, new Integer[]{2});
        Assert.assertThat((Object)constraint13.validate(this.path13, this.resourceContext), (Matcher)Matchers.is((Object)true));
        TierConstraint constraint23 = new TierConstraint(false, new Integer[]{3});
        Assert.assertThat((Object)constraint23.validate(this.path12, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testNotSatisfyExcludedTiers() {
        TierConstraint constraint12 = new TierConstraint(false, new Integer[]{1});
        Assert.assertThat((Object)constraint12.validate(this.path12, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint12.validate(this.path13, this.resourceContext), (Matcher)Matchers.is((Object)false));
        TierConstraint constraint13 = new TierConstraint(false, new Integer[]{2});
        Assert.assertThat((Object)constraint13.validate(this.path12, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint13.validate(this.path23, this.resourceContext), (Matcher)Matchers.is((Object)false));
        TierConstraint constraint23 = new TierConstraint(false, new Integer[]{3});
        Assert.assertThat((Object)constraint23.validate(this.path13, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint23.validate(this.path23, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testOrderCost() {
        TierConstraint constraint32 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{3, 2});
        Assert.assertThat((Object)constraint32.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)-1.0));
        Assert.assertThat((Object)constraint32.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)constraint32.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        TierConstraint constraint123 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{1, 2, 3});
        Assert.assertThat((Object)constraint123.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint123.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)constraint123.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)3.0));
        TierConstraint constraint231 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{2, 3, 1});
        Assert.assertThat((Object)constraint231.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)3.0));
        Assert.assertThat((Object)constraint231.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint231.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)2.0));
        TierConstraint constraint312 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{3, 1, 2});
        Assert.assertThat((Object)constraint312.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)constraint312.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)3.0));
        Assert.assertThat((Object)constraint312.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void testOrderCostWithDuplicates() {
        TierConstraint constraint32 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{3, 2, 1, 1, 2, 3});
        Assert.assertThat((Object)constraint32.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)3.0));
        Assert.assertThat((Object)constraint32.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)2.0));
        Assert.assertThat((Object)constraint32.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void testTierCost() {
        TierConstraint constraint123 = new TierConstraint(true, TierConstraint.CostType.TIER, new Integer[]{3, 1});
        Assert.assertThat((Object)constraint123.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint123.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)-1.0));
        Assert.assertThat((Object)constraint123.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)3.0));
    }

    @Test
    public void testValidCost() {
        TierConstraint constraint = new TierConstraint(true, TierConstraint.CostType.VALID, new Integer[]{2, 1});
        Assert.assertThat((Object)constraint.cost((Link)this.link1, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint.cost((Link)this.link2, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint.cost((Link)this.link3, this.resourceContext), (Matcher)Matchers.is((Object)-1.0));
    }

    @Test
    public void testEquality() {
        TierConstraint c1 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{3, 2, 1});
        TierConstraint c2 = new TierConstraint(true, TierConstraint.CostType.ORDER, new Integer[]{3, 2, 1});
        TierConstraint c3 = new TierConstraint(false, TierConstraint.CostType.TIER, new Integer[]{1});
        TierConstraint c4 = new TierConstraint(false, TierConstraint.CostType.TIER, new Integer[]{1});
        new EqualsTester().addEqualityGroup(new Object[]{c1, c2}).addEqualityGroup(new Object[]{c3, c4}).testEquals();
    }
}

