/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.inbandtelemetry;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.TpPort;

@Beta
public final class IntDeviceConfig {
    private final IpAddress collectorIp;
    private final TpPort collectorPort;
    private final MacAddress collectorNextHopMac;
    private final IpAddress sinkIp;
    private final MacAddress sinkMac;
    private final TelemetrySpec spec;
    private boolean enabled;
    private int hopLatencySensitivity;

    private IntDeviceConfig(IpAddress collectorIp, TpPort collectorPort, MacAddress collectorNextHopMac, IpAddress sinkIp, MacAddress sinkMac, TelemetrySpec spec, boolean enabled, int hopLatencySensitivity) {
        this.collectorIp = collectorIp;
        this.collectorPort = collectorPort;
        this.collectorNextHopMac = collectorNextHopMac;
        this.sinkIp = sinkIp;
        this.sinkMac = sinkMac;
        this.spec = spec;
        this.enabled = enabled;
        this.hopLatencySensitivity = hopLatencySensitivity;
    }

    public IpAddress collectorIp() {
        return this.collectorIp;
    }

    public TpPort collectorPort() {
        return this.collectorPort;
    }

    public MacAddress collectorNextHopMac() {
        return this.collectorNextHopMac;
    }

    public IpAddress sinkIp() {
        return this.sinkIp;
    }

    public MacAddress sinkMac() {
        return this.sinkMac;
    }

    public TelemetrySpec spec() {
        return this.spec;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public int minFlowHopLatencyChangeNs() {
        return this.hopLatencySensitivity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntDeviceConfig that = (IntDeviceConfig)o;
        return this.enabled == that.enabled && this.hopLatencySensitivity == that.hopLatencySensitivity && Objects.equal((Object)this.collectorIp, (Object)that.collectorIp) && Objects.equal((Object)this.collectorPort, (Object)that.collectorPort) && Objects.equal((Object)this.collectorNextHopMac, (Object)that.collectorNextHopMac) && Objects.equal((Object)this.sinkIp, (Object)that.sinkIp) && Objects.equal((Object)this.sinkMac, (Object)that.sinkMac) && this.spec == that.spec;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.collectorIp, this.collectorPort, this.collectorNextHopMac, this.sinkIp, this.sinkMac, this.spec, this.enabled, this.hopLatencySensitivity});
    }

    public static final class Builder {
        private IpAddress collectorIp = IpAddress.valueOf((int)0);
        private TpPort collectorPort = TpPort.tpPort((int)0);
        private MacAddress collectorNextHopMac = MacAddress.valueOf((long)0L);
        private IpAddress sinkIp = IpAddress.valueOf((int)0);
        private MacAddress sinkMac = MacAddress.valueOf((long)0L);
        private TelemetrySpec spec = TelemetrySpec.INT;
        private boolean enabled = false;
        int minFlowHopLatencyChangeNs = 0;

        public Builder withCollectorIp(IpAddress collectorIp) {
            this.collectorIp = collectorIp;
            return this;
        }

        public Builder withCollectorPort(TpPort collectorPort) {
            this.collectorPort = collectorPort;
            return this;
        }

        public Builder withCollectorNextHopMac(MacAddress collectorNextHopMac) {
            this.collectorNextHopMac = collectorNextHopMac;
            return this;
        }

        public Builder withSinkIp(IpAddress sinkIp) {
            this.sinkIp = sinkIp;
            return this;
        }

        public Builder withSinkMac(MacAddress sinkMac) {
            this.sinkMac = sinkMac;
            return this;
        }

        public Builder withTelemetrySpec(TelemetrySpec spec) {
            this.spec = spec;
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder withMinFlowHopLatencyChangeNs(int value) {
            this.minFlowHopLatencyChangeNs = value;
            return this;
        }

        public IntDeviceConfig build() {
            Preconditions.checkNotNull((Object)this.collectorIp, (Object)"Collector IP should be specified.");
            Preconditions.checkNotNull((Object)this.collectorPort, (Object)"Collector port number should be specified.");
            Preconditions.checkArgument((this.minFlowHopLatencyChangeNs >= 0 ? 1 : 0) != 0, (Object)"Hop latency sensitivity must be positive or zero");
            return new IntDeviceConfig(this.collectorIp, this.collectorPort, this.collectorNextHopMac, this.sinkIp, this.sinkMac, this.spec, this.enabled, this.minFlowHopLatencyChangeNs);
        }
    }

    public static enum TelemetrySpec {
        INT,
        IOAM;

    }
}

