/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class SessionDownlink
implements UpfEntity {
    private final Ip4Address ueAddress;
    private final Byte tunPeerId;
    private final boolean buffering;
    private final boolean dropping;

    private SessionDownlink(Ip4Address ipv4Address, Byte tunPeerId, boolean buffering, boolean drop) {
        this.ueAddress = ipv4Address;
        this.tunPeerId = tunPeerId;
        this.buffering = buffering;
        this.dropping = drop;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SessionDownlink that = (SessionDownlink)object;
        return this.buffering == that.buffering && this.dropping == that.dropping && Objects.equals(this.ueAddress, that.ueAddress) && Objects.equals(this.tunPeerId, that.tunPeerId);
    }

    public int hashCode() {
        return Objects.hash(this.ueAddress, this.tunPeerId, this.buffering, this.dropping);
    }

    public String toString() {
        return "UESessionDL{" + this.matchString() + " -> " + this.actionString() + "}";
    }

    private String matchString() {
        return "Match(ue_addr=" + this.ueAddress() + ")";
    }

    private String actionString() {
        StringBuilder actionStrBuilder = new StringBuilder("(");
        if (this.needsBuffering() && this.needsDropping()) {
            actionStrBuilder.append("BUFF+DROP, ");
        } else if (this.needsBuffering()) {
            actionStrBuilder.append("BUFF, ");
        } else if (this.needsDropping()) {
            actionStrBuilder.append("DROP, ");
        } else {
            actionStrBuilder.append("FWD, ");
        }
        return actionStrBuilder.append(" tun_peer=").append(this.tunPeerId()).append(")").toString();
    }

    public boolean needsBuffering() {
        return this.buffering;
    }

    public boolean needsDropping() {
        return this.dropping;
    }

    public Ip4Address ueAddress() {
        return this.ueAddress;
    }

    public Byte tunPeerId() {
        return this.tunPeerId;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.SESSION_DOWNLINK;
    }

    public static class Builder {
        private Ip4Address ueAddress = null;
        private Byte tunPeerId = null;
        private boolean buffer = false;
        private boolean drop = false;

        public Builder withUeAddress(Ip4Address ueAddress) {
            this.ueAddress = ueAddress;
            return this;
        }

        public Builder withGtpTunnelPeerId(Byte tunnelPeerId) {
            this.tunPeerId = tunnelPeerId;
            return this;
        }

        public Builder needsBuffering(boolean buffer) {
            this.buffer = buffer;
            return this;
        }

        public Builder needsDropping(boolean drop) {
            this.drop = drop;
            return this;
        }

        public SessionDownlink build() {
            Preconditions.checkNotNull((Object)this.ueAddress, (Object)"UE address must be provided");
            return new SessionDownlink(this.ueAddress, this.tunPeerId, this.buffer, this.drop);
        }
    }
}

