/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class SessionUplink
implements UpfEntity {
    private final Ip4Address tunDestAddr;
    private final Integer teid;
    private final boolean dropping;

    private SessionUplink(Ip4Address tunDestAddr, Integer teid, boolean drop) {
        this.tunDestAddr = tunDestAddr;
        this.teid = teid;
        this.dropping = drop;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SessionUplink that = (SessionUplink)object;
        return this.dropping == that.dropping && Objects.equals(this.tunDestAddr, that.tunDestAddr) && Objects.equals(this.teid, that.teid);
    }

    public int hashCode() {
        return Objects.hash(this.tunDestAddr, this.teid, this.dropping);
    }

    public String toString() {
        return "UESessionUL{" + this.matchString() + " -> " + this.actionString() + "}";
    }

    private String matchString() {
        return "Match(tun_dst_addr=" + this.tunDstAddr() + ", TEID=" + this.teid() + ")";
    }

    private String actionString() {
        StringBuilder actionStrBuilder = new StringBuilder("(");
        if (this.needsDropping()) {
            actionStrBuilder.append("DROP");
        } else {
            actionStrBuilder.append("FWD");
        }
        return actionStrBuilder.append(")").toString();
    }

    public boolean needsDropping() {
        return this.dropping;
    }

    public Ip4Address tunDstAddr() {
        return this.tunDestAddr;
    }

    public Integer teid() {
        return this.teid;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.SESSION_UPLINK;
    }

    public static class Builder {
        private Ip4Address tunDstAddr = null;
        private Integer teid = null;
        private boolean drop = false;

        public Builder withTunDstAddr(Ip4Address tunDstAddr) {
            this.tunDstAddr = tunDstAddr;
            return this;
        }

        public Builder withTeid(Integer teid) {
            this.teid = teid;
            return this;
        }

        public Builder needsDropping(boolean drop) {
            this.drop = drop;
            return this;
        }

        public SessionUplink build() {
            Preconditions.checkNotNull((Object)this.tunDstAddr, (Object)"Tunnel destination must be provided");
            Preconditions.checkNotNull((Object)this.teid, (Object)"TEID must be provided");
            return new SessionUplink(this.tunDstAddr, this.teid, this.drop);
        }
    }
}

