/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Objects;
import java.util.Optional;
import org.onlab.packet.Ip4Prefix;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class UpfApplication
implements UpfEntity {
    private final Ip4Prefix ipPrefix;
    private final Range<Short> l4PortRange;
    private final Byte ipProto;
    private final byte appId;
    private final int priority;

    private UpfApplication(Ip4Prefix ipPrefix, Range<Short> l4PortRange, Byte ipProto, byte appId, int priority) {
        this.ipPrefix = ipPrefix;
        this.l4PortRange = l4PortRange;
        this.ipProto = ipProto;
        this.appId = appId;
        this.priority = priority;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UpfApplication that = (UpfApplication)object;
        return Objects.equals(this.ipPrefix, that.ipPrefix) && Objects.equals(this.l4PortRange, that.l4PortRange) && Objects.equals(this.ipProto, that.ipProto) && this.appId == that.appId && this.priority == that.priority;
    }

    public int hashCode() {
        return Objects.hash(this.ipPrefix, this.l4PortRange, this.ipProto, this.appId, this.priority);
    }

    public String toString() {
        return "UpfApplication{priority=" + this.priority + ", " + this.matchString() + " -> " + this.actionString() + "}";
    }

    private String matchString() {
        StringBuilder matchStrBuilder = new StringBuilder("Match(");
        if (this.ipPrefix != null) {
            matchStrBuilder.append("ip_prefix=").append(this.ipPrefix).append(", ");
        }
        if (this.l4PortRange != null) {
            matchStrBuilder.append("l4_port_range=").append(this.l4PortRange).append(", ");
        }
        if (this.ipProto != null) {
            matchStrBuilder.append("ip_proto=").append(this.ipProto).append(", ");
        }
        matchStrBuilder.delete(matchStrBuilder.length() - 2, matchStrBuilder.length());
        return matchStrBuilder.append(")").toString();
    }

    private String actionString() {
        return "(app_id=" + this.appId + ")";
    }

    public Optional<Ip4Prefix> ip4Prefix() {
        return Optional.ofNullable(this.ipPrefix);
    }

    public Optional<Range<Short>> l4PortRange() {
        return Optional.ofNullable(this.l4PortRange);
    }

    public Optional<Byte> ipProto() {
        return Optional.ofNullable(this.ipProto);
    }

    public byte appId() {
        return this.appId;
    }

    public int priority() {
        return this.priority;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.APPLICATION;
    }

    public static class Builder {
        private Ip4Prefix ipPrefix = null;
        private Range<Short> l4PortRange = null;
        private Byte ipProto = null;
        private Byte appId = null;
        private Integer priority = null;

        public Builder withIp4Prefix(Ip4Prefix ipPrefix) {
            this.ipPrefix = ipPrefix;
            return this;
        }

        public Builder withL4PortRange(Range<Short> l4PortRange) {
            Preconditions.checkArgument((l4PortRange.hasLowerBound() && l4PortRange.hasUpperBound() ? 1 : 0) != 0, (Object)"Range must be provided with bounds");
            this.l4PortRange = l4PortRange;
            return this;
        }

        public Builder withIpProto(byte ipProto) {
            this.ipProto = ipProto;
            return this;
        }

        public Builder withAppId(byte appId) {
            this.appId = appId;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public UpfApplication build() {
            Preconditions.checkArgument((this.ipPrefix != null || this.l4PortRange != null || this.ipProto != null ? 1 : 0) != 0, (Object)"At least one match field is required");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Application ID must be provided");
            Preconditions.checkNotNull((Object)this.priority, (Object)"Priority must be provided");
            return new UpfApplication(this.ipPrefix, this.l4PortRange, this.ipProto, this.appId, this.priority);
        }
    }
}

