/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class UpfCounter
implements UpfEntity {
    private final int cellId;
    private final long ingressPkts;
    private final long ingressBytes;
    private final long egressPkts;
    private final long egressBytes;

    private UpfCounter(int cellId, long ingressPkts, long ingressBytes, long egressPkts, long egressBytes) {
        this.cellId = cellId;
        this.ingressPkts = ingressPkts;
        this.ingressBytes = ingressBytes;
        this.egressPkts = egressPkts;
        this.egressBytes = egressBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("Stats:{ CellID: %d, Ingress:(%dpkts,%dbytes), Egress:(%dpkts,%dbytes) }", this.cellId, this.ingressPkts, this.ingressBytes, this.egressPkts, this.egressBytes);
    }

    public int getCellId() {
        return this.cellId;
    }

    public long getIngressPkts() {
        return this.ingressPkts;
    }

    public long getEgressPkts() {
        return this.egressPkts;
    }

    public long getIngressBytes() {
        return this.ingressBytes;
    }

    public long getEgressBytes() {
        return this.egressBytes;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.COUNTER;
    }

    public static class Builder {
        private Integer cellId;
        private long ingressPkts = 0L;
        private long ingressBytes = 0L;
        private long egressPkts = 0L;
        private long egressBytes = 0L;

        public Builder withCellId(int cellId) {
            this.cellId = cellId;
            return this;
        }

        public Builder setIngress(long ingressPkts, long ingressBytes) {
            this.ingressPkts = ingressPkts;
            this.ingressBytes = ingressBytes;
            return this;
        }

        public Builder setEgress(long egressPkts, long egressBytes) {
            this.egressPkts = egressPkts;
            this.egressBytes = egressBytes;
            return this;
        }

        public UpfCounter build() {
            Preconditions.checkNotNull((Object)this.cellId, (Object)"CellID must be provided");
            return new UpfCounter(this.cellId, this.ingressPkts, this.ingressBytes, this.egressPkts, this.egressBytes);
        }
    }
}

