/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.trafficcontrol;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.behaviour.trafficcontrol.PolicerId;
import org.onosproject.net.behaviour.trafficcontrol.PolicingResource;

public class PolicingResourceTest {
    private static final String SCP1 = "of:00000000000001/1";
    private static final String SCP2 = "of:00000000000001/2";
    private static final ConnectPoint CP1 = ConnectPoint.deviceConnectPoint((String)"of:00000000000001/1");
    private static final ConnectPoint CP2 = ConnectPoint.deviceConnectPoint((String)"of:00000000000001/2");
    private static final String OF_SCHEME = "of";
    private static final String SID = "of:" + Integer.toHexString(1);
    private static final PolicerId PID = PolicerId.policerId((String)SID);
    @Rule
    public ExpectedException exceptionNullId = ExpectedException.none();

    @Test
    public void testCreation() {
        PolicingResource policingResource = new PolicingResource(PID, CP1);
        Assert.assertThat((Object)policingResource, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)policingResource.policerId(), (Matcher)Matchers.is((Object)PID));
        Assert.assertThat((Object)policingResource.connectPoint(), (Matcher)Matchers.is((Object)CP1));
    }

    @Test
    public void testNullIdCreation() {
        this.exceptionNullId.expect(NullPointerException.class);
        new PolicingResource(null, CP1);
    }

    @Test
    public void testEqualilty() {
        PolicingResource one = new PolicingResource(PID, CP1);
        PolicingResource copyOfOne = new PolicingResource(PID, CP1);
        Assert.assertEquals((Object)one, (Object)copyOfOne);
        PolicingResource two = new PolicingResource(PID, CP2);
        Assert.assertNotEquals((Object)two, (Object)one);
        Assert.assertNotEquals((Object)two, (Object)copyOfOne);
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PolicingResource.class);
    }
}

