/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.HostId;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.config.SubjectFactory;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class SubjectFactoriesTest {
    @Before
    public void setUp() {
        SubjectFactories.setCoreService((CoreService)new TestCoreService());
    }

    @Test
    public void testAppIdFactory() {
        SubjectFactory appIdFactory = SubjectFactories.APP_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)appIdFactory, (Matcher)Matchers.notNullValue());
        ApplicationId id = NetTestTools.APP_ID;
        ApplicationId createdAppId = (ApplicationId)appIdFactory.createSubject(id.name());
        MatcherAssert.assertThat((Object)createdAppId.id(), (Matcher)Matchers.equalTo((Object)id.id()));
        MatcherAssert.assertThat((Object)appIdFactory.subjectKey((Object)id), (Matcher)Matchers.is((Object)id.name()));
    }

    @Test
    public void testDeviceIdFactory() {
        SubjectFactory deviceIdFactory = SubjectFactories.DEVICE_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)deviceIdFactory, (Matcher)Matchers.notNullValue());
        String deviceName = "d1";
        String ofDeviceName = "of:" + deviceName;
        DeviceId id = NetTestTools.did(deviceName);
        DeviceId createdDeviceId = (DeviceId)deviceIdFactory.createSubject(ofDeviceName);
        MatcherAssert.assertThat((Object)createdDeviceId, (Matcher)Matchers.equalTo((Object)id));
        MatcherAssert.assertThat((Object)deviceIdFactory.subjectKey((Object)id), (Matcher)Matchers.is((Object)ofDeviceName));
    }

    @Test
    public void testConnectPointFactory() {
        SubjectFactory connectPointFactory = SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)connectPointFactory, (Matcher)Matchers.notNullValue());
        String deviceName = "d1";
        String ofDeviceName = "of:" + deviceName;
        int devicePort = 2;
        String cpString = ofDeviceName + "/" + Integer.toString(devicePort);
        ConnectPoint cp = NetTestTools.connectPoint(deviceName, devicePort);
        ConnectPoint createdConnectPoint = (ConnectPoint)connectPointFactory.createSubject(cpString);
        MatcherAssert.assertThat((Object)createdConnectPoint, (Matcher)Matchers.equalTo((Object)cp));
        MatcherAssert.assertThat((Object)connectPointFactory.subjectKey((Object)cp), (Matcher)Matchers.is((Object)cpString));
    }

    @Test
    public void testHostFactory() {
        SubjectFactory hostFactory = SubjectFactories.HOST_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)hostFactory, (Matcher)Matchers.notNullValue());
        String hostName = "11:11:11:11:11:11/3";
        HostId hostId = NetTestTools.hid(hostName);
        HostId createdHostId = (HostId)hostFactory.createSubject(hostName);
        MatcherAssert.assertThat((Object)createdHostId, (Matcher)Matchers.equalTo((Object)hostId));
        MatcherAssert.assertThat((Object)hostFactory.subjectKey((Object)hostId), (Matcher)Matchers.is((Object)hostId.toString()));
    }

    @Test
    public void testLinkFactory() {
        SubjectFactory linkFactory = SubjectFactories.LINK_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)linkFactory, (Matcher)Matchers.notNullValue());
        String deviceName1 = "d1";
        String deviceName2 = "d2";
        String ofDeviceName1 = "of:" + deviceName1;
        String ofDeviceName2 = "of:" + deviceName2;
        int devicePort1 = 2;
        int devicePort2 = 3;
        String cpString1 = ofDeviceName1 + "/" + Integer.toString(devicePort1);
        String cpString2 = ofDeviceName2 + "/" + Integer.toString(devicePort2);
        ConnectPoint cp1 = NetTestTools.connectPoint(deviceName1, devicePort1);
        ConnectPoint cp2 = NetTestTools.connectPoint(deviceName2, devicePort2);
        String linkString1 = cpString1 + "-" + cpString2;
        LinkKey key1 = LinkKey.linkKey((ConnectPoint)cp1, (ConnectPoint)cp2);
        LinkKey createdLink1 = (LinkKey)linkFactory.createSubject(linkString1);
        MatcherAssert.assertThat((Object)createdLink1.asId(), (Matcher)Matchers.is((Object)linkString1));
        MatcherAssert.assertThat((Object)linkFactory.subjectKey((Object)key1), (Matcher)Matchers.is((Object)linkString1));
    }

    @Test
    public void testRegionIdFactory() {
        SubjectFactory regionIdFactory = SubjectFactories.REGION_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)regionIdFactory, (Matcher)Matchers.notNullValue());
        String region1 = "region1";
        RegionId id = RegionId.regionId((String)region1);
        RegionId createdRegionId = (RegionId)regionIdFactory.createSubject(region1);
        MatcherAssert.assertThat((Object)((String)createdRegionId.id()), (Matcher)Matchers.equalTo((Object)region1));
        MatcherAssert.assertThat((Object)regionIdFactory.subjectKey((Object)id), (Matcher)Matchers.is((Object)region1));
    }

    @Test
    public void testUITopoLayoutIdFactory() {
        SubjectFactory uiTopoLayoutIdFactory = SubjectFactories.LAYOUT_SUBJECT_FACTORY;
        MatcherAssert.assertThat((Object)uiTopoLayoutIdFactory, (Matcher)Matchers.notNullValue());
        String layout1 = "layout1";
        UiTopoLayoutId id = UiTopoLayoutId.layoutId((String)layout1);
        UiTopoLayoutId createdLayouId = (UiTopoLayoutId)uiTopoLayoutIdFactory.createSubject(layout1);
        MatcherAssert.assertThat((Object)((String)createdLayouId.id()), (Matcher)Matchers.equalTo((Object)layout1));
        MatcherAssert.assertThat((Object)uiTopoLayoutIdFactory.subjectKey((Object)id), (Matcher)Matchers.is((Object)layout1));
    }

    class TestCoreService
    extends CoreServiceAdapter {
        TestCoreService() {
        }

        @Override
        public ApplicationId registerApplication(String key) {
            return new TestApplicationId(key);
        }
    }
}

