/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.AnnotationConstraint;
import org.onosproject.net.provider.ProviderId;

public class AnnotationConstraintTest {
    private static final ProviderId PID = new ProviderId("of", "foo");
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final PortNumber PID1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PID2 = PortNumber.portNumber((long)2L);
    private static final String KEY = "distance";
    private static final String MISSING_KEY = "loss";
    private static final double VALUE = 100.0;
    private AnnotationConstraint sut;
    private Link link;
    private ResourceContext resourceContext;

    @Before
    public void setUp() {
        this.resourceContext = (ResourceContext)EasyMock.createMock(ResourceContext.class);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set(KEY, String.valueOf(100.0)).build();
        this.link = DefaultLink.builder().providerId(PID).src(DefaultLinkTest.cp((ElementId)DID1, PID1)).dst(DefaultLinkTest.cp((ElementId)DID2, PID2)).type(Link.Type.DIRECT).annotations((Annotations)annotations).build();
    }

    @Test
    public void testLessThanThreshold() {
        double value = 120.0;
        this.sut = new AnnotationConstraint(KEY, value);
        Assert.assertThat((Object)this.sut.isValid(this.link, this.resourceContext), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)this.sut.cost(this.link, this.resourceContext), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)100.0, (double)1.0E-6)));
    }

    @Test
    public void testMoreThanThreshold() {
        double value = 80.0;
        this.sut = new AnnotationConstraint(KEY, value);
        Assert.assertThat((Object)this.sut.isValid(this.link, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.sut.cost(this.link, this.resourceContext), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Double.valueOf(0.0))));
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{new AnnotationConstraint(KEY, 100.0), new AnnotationConstraint(KEY, 100.0)}).addEqualityGroup(new Object[]{new AnnotationConstraint(KEY, 120.0)}).addEqualityGroup(new Object[]{new AnnotationConstraint("latency", 100.0)}).testEquals();
    }

    @Test
    public void testNotAnnotated() {
        this.sut = new AnnotationConstraint(MISSING_KEY, 80.0);
        Assert.assertThat((Object)this.link.annotations().value(MISSING_KEY), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)this.sut.isValid(this.link, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)this.sut.cost(this.link, this.resourceContext), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Double.valueOf(0.0))));
    }
}

