/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultLinkTest;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.MeteredConstraint;
import org.onosproject.net.provider.ProviderId;

public class MeteredConstraintTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"of:1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"of:2");
    private static final DeviceId DID3 = DeviceId.deviceId((String)"of:3");
    private static final PortNumber PN1 = PortNumber.portNumber((long)1L);
    private static final PortNumber PN2 = PortNumber.portNumber((long)2L);
    private static final PortNumber PN3 = PortNumber.portNumber((long)3L);
    private static final PortNumber PN4 = PortNumber.portNumber((long)4L);
    private static final PortNumber PN5 = PortNumber.portNumber((long)5L);
    private static final PortNumber PN6 = PortNumber.portNumber((long)6L);
    private static final ProviderId PROVIDER_ID = new ProviderId("of", "foo");
    private static final String METERED1 = String.valueOf(true);
    private static final String METERED2 = String.valueOf(false);
    private ResourceContext resourceContext;
    private Path meteredPath;
    private Path nonMeteredPath;
    private Link meteredLink;
    private Link nonMeteredLink;
    private Link unAnnotatedLink;

    @Before
    public void setUp() {
        this.resourceContext = (ResourceContext)EasyMock.createMock(ResourceContext.class);
        DefaultAnnotations annotations1 = DefaultAnnotations.builder().set("metered", METERED1).build();
        DefaultAnnotations annotations2 = DefaultAnnotations.builder().set("metered", METERED2).build();
        this.meteredLink = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID1, PN1)).dst(DefaultLinkTest.cp((ElementId)DID2, PN2)).type(Link.Type.DIRECT).annotations((Annotations)annotations1).build();
        this.nonMeteredLink = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID2, PN3)).dst(DefaultLinkTest.cp((ElementId)DID3, PN4)).type(Link.Type.DIRECT).annotations((Annotations)annotations2).build();
        this.unAnnotatedLink = DefaultLink.builder().providerId(PROVIDER_ID).src(DefaultLinkTest.cp((ElementId)DID1, PN5)).dst(DefaultLinkTest.cp((ElementId)DID3, PN6)).type(Link.Type.DIRECT).build();
        this.meteredPath = new DefaultPath(PROVIDER_ID, Arrays.asList(this.meteredLink, this.nonMeteredLink), (Weight)ScalarWeight.toWeight((double)10.0), new Annotations[0]);
        this.nonMeteredPath = new DefaultPath(PROVIDER_ID, Arrays.asList(this.nonMeteredLink, this.unAnnotatedLink), (Weight)ScalarWeight.toWeight((double)10.0), new Annotations[0]);
    }

    @Test
    public void testAllowedOnAllPaths() {
        MeteredConstraint constraint = new MeteredConstraint(true);
        Assert.assertThat((Object)constraint.validate(this.meteredPath, this.resourceContext), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)constraint.validate(this.nonMeteredPath, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void tesNotAllowedOntMeteredPath() {
        MeteredConstraint constraint = new MeteredConstraint(false);
        Assert.assertThat((Object)constraint.validate(this.meteredPath, this.resourceContext), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testNotAllowsOnNonMeteredPath() {
        MeteredConstraint constraint = new MeteredConstraint(false);
        Assert.assertThat((Object)constraint.validate(this.nonMeteredPath, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMeteredAllowed() {
        MeteredConstraint constraint = new MeteredConstraint(true);
        Assert.assertThat((Object)constraint.isValid(this.meteredLink, this.resourceContext), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)constraint.isValid(this.nonMeteredLink, this.resourceContext), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)constraint.isValid(this.unAnnotatedLink, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMeteredNotAllowed() {
        MeteredConstraint constraint = new MeteredConstraint(false);
        Assert.assertThat((Object)constraint.isValid(this.meteredLink, this.resourceContext), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)constraint.isValid(this.nonMeteredLink, this.resourceContext), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)constraint.isValid(this.unAnnotatedLink, this.resourceContext), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCostAllowed() {
        MeteredConstraint constraint = new MeteredConstraint(true);
        Assert.assertThat((Object)constraint.cost(this.meteredLink, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint.cost(this.nonMeteredLink, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint.cost(this.unAnnotatedLink, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void testCostNotAllowed() {
        MeteredConstraint constraint = new MeteredConstraint(false);
        Assert.assertThat((Object)constraint.cost(this.meteredLink, this.resourceContext), (Matcher)Matchers.is((Object)-1.0));
        Assert.assertThat((Object)constraint.cost(this.nonMeteredLink, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
        Assert.assertThat((Object)constraint.cost(this.unAnnotatedLink, this.resourceContext), (Matcher)Matchers.is((Object)1.0));
    }

    @Test
    public void testEquality() {
        MeteredConstraint c1 = new MeteredConstraint(true);
        MeteredConstraint c2 = new MeteredConstraint(true);
        MeteredConstraint c3 = new MeteredConstraint(false);
        MeteredConstraint c4 = new MeteredConstraint(false);
        new EqualsTester().addEqualityGroup(new Object[]{c1, c2}).addEqualityGroup(new Object[]{c3, c4}).testEquals();
    }
}

