/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultMeterFeatures;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterScope;

public class DefaultMeterFeaturesTest {
    private MeterFeatures mf;
    private DeviceId did = DeviceId.deviceId((String)"foo:foo");
    private short band = (short)2;
    private short color = (short)3;
    private Set<Band.Type> types;
    private Set<Meter.Unit> units;
    private MeterScope globalScope = MeterScope.globalScope();
    private MeterScope fooScope = MeterScope.of((String)"foo");

    @Before
    public void setup() {
        this.types = Set.of(Band.Type.DROP);
        this.units = Set.of(Meter.Unit.KB_PER_SEC);
    }

    @Test
    public void testZeroMaxMeter() {
        this.mf = DefaultMeterFeatures.builder().forDevice(this.did).withMaxMeters(0L).withScope(this.globalScope).withMaxBands(this.band).withMaxColors(this.color).withBandTypes(this.types).withUnits(this.units).hasBurst(true).hasStats(true).build();
        Assert.assertEquals((long)-1L, (long)this.mf.startIndex());
        Assert.assertEquals((long)-1L, (long)this.mf.endIndex());
        Assert.assertEquals((long)0L, (long)this.mf.maxMeter());
    }

    @Test
    public void testOfMaxMeter() {
        this.mf = DefaultMeterFeatures.builder().forDevice(this.did).withMaxMeters(1024L).withScope(this.globalScope).withMaxBands(this.band).withMaxColors(this.color).withBandTypes(this.types).withUnits(this.units).hasBurst(true).hasStats(true).build();
        Assert.assertEquals((long)1L, (long)this.mf.startIndex());
        Assert.assertEquals((long)1024L, (long)this.mf.endIndex());
        Assert.assertEquals((long)1024L, (long)this.mf.maxMeter());
    }

    @Test
    public void testNonOfMaxMeter() {
        this.mf = DefaultMeterFeatures.builder().forDevice(this.did).withMaxMeters(1024L).withScope(this.fooScope).withMaxBands(this.band).withMaxColors(this.color).withBandTypes(this.types).withUnits(this.units).hasBurst(true).hasStats(true).build();
        Assert.assertEquals((long)0L, (long)this.mf.startIndex());
        Assert.assertEquals((long)1023L, (long)this.mf.endIndex());
        Assert.assertEquals((long)1024L, (long)this.mf.maxMeter());
    }
}

