/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.ContinuousResourceId;
import org.onosproject.net.resource.Resources;

public class ContinuousResourceIdTest {
    private static final DeviceId D1 = DeviceId.deviceId((String)"of:001");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final Bandwidth BW1 = Bandwidth.gbps((long)2L);
    private static final Bandwidth BW2 = Bandwidth.gbps((long)1L);

    @Test
    public void testEquality() {
        ContinuousResourceId id1 = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps()).id();
        ContinuousResourceId sameAsId1 = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW2.bps()).id();
        new EqualsTester().addEqualityGroup(new Object[]{id1, sameAsId1}).testEquals();
    }

    @Test
    public void testSimpleTypeName() {
        ContinuousResourceId id1 = Resources.continuous((DeviceId)D1, (PortNumber)P1, Bandwidth.class).resource(BW1.bps()).id();
        Assert.assertThat((Object)id1.simpleTypeName(), (Matcher)Matchers.is((Object)"Bandwidth"));
    }
}

