/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.cluster.messaging;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.store.cluster.messaging.ClusterMessage;
import org.onosproject.store.cluster.messaging.MessageSubject;

public class ClusterMessageTest {
    private final MessageSubject subject1 = new MessageSubject("Message 1");
    private final MessageSubject subject2 = new MessageSubject("Message 2");
    private final byte[] payload1 = new byte[]{0, 1, 2, 3, 4, 5};
    private final byte[] payload2 = new byte[]{0, 1, 2, 3, 4, 5, 6};
    private final NodeId nodeId = new NodeId("node");
    private final ClusterMessage message1 = new ClusterMessage(this.nodeId, this.subject1, this.payload1);
    private final ClusterMessage sameAsMessage1 = new ClusterMessage(this.nodeId, this.subject1, this.payload1);
    private final ClusterMessage message2 = new ClusterMessage(this.nodeId, this.subject1, this.payload2);
    private final ClusterMessage message3 = new ClusterMessage(this.nodeId, this.subject2, this.payload1);

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.message1, this.sameAsMessage1}).addEqualityGroup(new Object[]{this.message2}).addEqualityGroup(new Object[]{this.message3}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.message1.payload(), (Matcher)Matchers.is((Object)this.payload1));
        MatcherAssert.assertThat((Object)this.message1.sender(), (Matcher)Matchers.is((Object)this.nodeId));
        MatcherAssert.assertThat((Object)this.message1.subject(), (Matcher)Matchers.is((Object)this.subject1));
        byte[] response = new byte[]{2, 2, 2, 2, 2, 2, 2, 2};
        this.message1.respond(response);
        MatcherAssert.assertThat((Object)this.message1.response(), (Matcher)Matchers.is((Object)response));
    }

    @Test
    public void testByteMethods() {
        byte[] fromBytes = this.message3.getBytes();
        ClusterMessage message = ClusterMessage.fromBytes((byte[])fromBytes);
        MatcherAssert.assertThat((Object)message, (Matcher)Matchers.is((Object)this.message3));
    }
}

