/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DataPlaneEntity;
import org.onosproject.net.PipelineTraceablePacket;

public final class PipelineTraceableHitChain {
    private ConnectPoint outputPort;
    private List<DataPlaneEntity> hitChain;
    private PipelineTraceablePacket egressPacket;
    private boolean dropped = true;

    private PipelineTraceableHitChain() {
        this.hitChain = Lists.newArrayList();
    }

    public PipelineTraceableHitChain(ConnectPoint output, List<DataPlaneEntity> hits, PipelineTraceablePacket packet) {
        this.outputPort = output;
        this.hitChain = hits;
        this.egressPacket = packet;
    }

    public static PipelineTraceableHitChain emptyHitChain() {
        return new PipelineTraceableHitChain();
    }

    public ConnectPoint outputPort() {
        return this.outputPort;
    }

    public void setOutputPort(ConnectPoint outputPort) {
        this.outputPort = outputPort;
    }

    public List<DataPlaneEntity> hitChain() {
        return this.hitChain;
    }

    public void addDataPlaneEntity(DataPlaneEntity dataPlaneEntity) {
        if (!this.hitChain.contains(dataPlaneEntity)) {
            this.hitChain.add(dataPlaneEntity);
        }
    }

    public void removeDataPlaneEntity(DataPlaneEntity dataPlaneEntity) {
        if (this.hitChain.isEmpty()) {
            return;
        }
        this.hitChain.remove(dataPlaneEntity);
    }

    public PipelineTraceablePacket egressPacket() {
        return this.egressPacket;
    }

    public void setEgressPacket(PipelineTraceablePacket egressPacket) {
        this.egressPacket = egressPacket;
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public void dropped() {
        this.dropped = true;
    }

    public void pass() {
        this.dropped = false;
    }

    public int hashCode() {
        return Objects.hash(this.outputPort, this.hitChain, this.egressPacket, this.dropped);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PipelineTraceableHitChain) {
            PipelineTraceableHitChain that = (PipelineTraceableHitChain)obj;
            return Objects.equals(this.outputPort, that.outputPort) && Objects.equals(this.hitChain, that.hitChain) && Objects.equals(this.egressPacket, that.egressPacket) && Objects.equals(this.dropped, that.dropped);
        }
        return false;
    }

    public String toString() {
        return "PipelineTraceableHitChain{outputPort=" + this.outputPort + ", hitChain=" + this.hitChain + ", egressPacket=" + this.egressPacket + ", dropped=" + this.dropped + "}";
    }
}

