/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class UpfGtpTunnelPeer
implements UpfEntity {
    private final byte tunPeerId;
    private final Ip4Address src;
    private final Ip4Address dst;
    private final short srcPort;

    private UpfGtpTunnelPeer(byte tunPeerId, Ip4Address src, Ip4Address dst, short srcPort) {
        this.tunPeerId = tunPeerId;
        this.src = src;
        this.dst = dst;
        this.srcPort = srcPort;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("UpfGtpTunnelPeer(tunn_peer_id=%s -> src=%s, dst=%s src_port=%s)", this.tunPeerId, this.src.toString(), this.dst.toString(), this.srcPort);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UpfGtpTunnelPeer that = (UpfGtpTunnelPeer)object;
        return this.tunPeerId == that.tunPeerId && this.src.equals((Object)that.src) && this.dst.equals((Object)that.dst) && this.srcPort == that.srcPort;
    }

    public int hashCode() {
        return Objects.hash(this.tunPeerId, this.src, this.dst, this.srcPort);
    }

    public byte tunPeerId() {
        return this.tunPeerId;
    }

    public Ip4Address src() {
        return this.src;
    }

    public Ip4Address dst() {
        return this.dst;
    }

    public short srcPort() {
        return this.srcPort;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.TUNNEL_PEER;
    }

    public static class Builder {
        private Byte tunPeerId = null;
        private Ip4Address src = null;
        private Ip4Address dst = null;
        private short srcPort = (short)2152;

        public Builder withTunnelPeerId(byte tunPeerId) {
            this.tunPeerId = tunPeerId;
            return this;
        }

        public Builder withSrcAddr(Ip4Address src) {
            this.src = src;
            return this;
        }

        public Builder withDstAddr(Ip4Address dst) {
            this.dst = dst;
            return this;
        }

        public Builder withSrcPort(short srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        public UpfGtpTunnelPeer build() {
            Preconditions.checkArgument((this.tunPeerId != null ? 1 : 0) != 0, (Object)"Tunnel Peer ID must be provided");
            Preconditions.checkArgument((this.src != null ? 1 : 0) != 0, (Object)"Tunnel source address cannot be null");
            Preconditions.checkArgument((this.dst != null ? 1 : 0) != 0, (Object)"Tunnel destination address cannot be null");
            return new UpfGtpTunnelPeer(this.tunPeerId, this.src, this.dst, this.srcPort);
        }
    }
}

