/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class UpfInterface
implements UpfEntity {
    private final Ip4Prefix prefix;
    private final Type type;
    private final int sliceId;

    private UpfInterface(Ip4Prefix prefix, Type type, int sliceId) {
        this.prefix = prefix;
        this.type = type;
        this.sliceId = sliceId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("UpfInterface(type=%s, prefix=%s, slice_id=%s)", this.type.toString(), this.prefix, this.sliceId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpfInterface that = (UpfInterface)obj;
        return this.type.equals((Object)that.type) && this.prefix.equals((Object)that.prefix) && this.sliceId == that.sliceId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.type, this.sliceId});
    }

    public static UpfInterface createN3From(Ip4Address address, int sliceId) {
        return UpfInterface.builder().setAccess().setPrefix(Ip4Prefix.valueOf((Ip4Address)address, (int)32)).setSliceId(sliceId).build();
    }

    public static UpfInterface createUePoolFrom(Ip4Prefix prefix, int sliceId) {
        return UpfInterface.builder().setCore().setPrefix(prefix).setSliceId(sliceId).build();
    }

    public static UpfInterface createDbufReceiverFrom(Ip4Address address, int sliceId) {
        return UpfInterface.builder().setDbufReceiver().setAddress(address).setSliceId(sliceId).build();
    }

    public Ip4Prefix prefix() {
        return this.prefix;
    }

    public int sliceId() {
        return this.sliceId;
    }

    public boolean isAccess() {
        return this.type == Type.ACCESS;
    }

    public boolean isCore() {
        return this.type == Type.CORE;
    }

    public boolean isDbufReceiver() {
        return this.type == Type.DBUF;
    }

    public Ip4Prefix getPrefix() {
        return this.prefix;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.INTERFACE;
    }

    public static class Builder {
        private Ip4Prefix prefix;
        private Type type = Type.UNKNOWN;
        private Integer sliceId;

        public Builder setPrefix(Ip4Prefix prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setSliceId(int sliceId) {
            this.sliceId = sliceId;
            return this;
        }

        public Builder setAddress(Ip4Address address) {
            this.prefix = Ip4Prefix.valueOf((Ip4Address)address, (int)32);
            return this;
        }

        public Builder setAccess() {
            this.type = Type.ACCESS;
            return this;
        }

        public Builder setCore() {
            this.type = Type.CORE;
            return this;
        }

        public Builder setDbufReceiver() {
            this.type = Type.DBUF;
            return this;
        }

        public UpfInterface build() {
            Preconditions.checkNotNull((Object)this.prefix, (Object)"The IPv4 prefix must be provided");
            Preconditions.checkNotNull((Object)this.sliceId, (Object)"Slice ID must be provided");
            return new UpfInterface(this.prefix, this.type, this.sliceId);
        }
    }

    public static enum Type {
        UNKNOWN,
        ACCESS,
        CORE,
        DBUF;

    }
}

