/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;

public final class UpfMeter
implements UpfEntity {
    private final int cellId;
    private final ImmutableMap<Band.Type, Band> meterBands;
    private final UpfEntityType type;

    private UpfMeter(int cellId, Map<Band.Type, Band> meterBands, UpfEntityType type) {
        this.cellId = cellId;
        this.meterBands = ImmutableMap.copyOf(meterBands);
        this.type = type;
    }

    public String toString() {
        return String.format("UpfMeter(type=%s, index=%d, committed=%s, peak=%s)", new Object[]{this.type, this.cellId, this.committedBand().orElse(null), this.peakBand().orElse(null)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UpfMeter that = (UpfMeter)object;
        return this.type.equals((Object)that.type) && this.cellId == that.cellId && this.meterBands.equals(that.meterBands);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.cellId, this.meterBands});
    }

    @Override
    public UpfEntityType type() {
        return this.type;
    }

    public int cellId() {
        return this.cellId;
    }

    public Optional<Band> committedBand() {
        return Optional.ofNullable((Band)this.meterBands.getOrDefault((Object)Band.Type.MARK_YELLOW, null));
    }

    public Optional<Band> peakBand() {
        return Optional.ofNullable((Band)this.meterBands.getOrDefault((Object)Band.Type.MARK_RED, null));
    }

    public boolean isSession() {
        return this.type.equals((Object)UpfEntityType.SESSION_METER);
    }

    public boolean isApplication() {
        return this.type.equals((Object)UpfEntityType.APPLICATION_METER);
    }

    public boolean isReset() {
        return this.meterBands.isEmpty();
    }

    public static UpfMeter resetSession(int cellId) {
        return new UpfMeter(cellId, Maps.newHashMap(), UpfEntityType.SESSION_METER);
    }

    public static UpfMeter resetApplication(int cellId) {
        return new UpfMeter(cellId, Maps.newHashMap(), UpfEntityType.APPLICATION_METER);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer cellId = null;
        private Map<Band.Type, Band> bands = Maps.newHashMap();
        private UpfEntityType type;

        public Builder setCellId(int cellId) {
            this.cellId = cellId;
            return this;
        }

        public Builder setCommittedBand(long cir, long cburst) {
            this.bands.put(Band.Type.MARK_YELLOW, DefaultBand.builder().ofType(Band.Type.MARK_YELLOW).withRate(cir).burstSize(cburst).build());
            return this;
        }

        public Builder setPeakBand(long pir, long pburst) {
            this.bands.put(Band.Type.MARK_RED, DefaultBand.builder().ofType(Band.Type.MARK_RED).withRate(pir).burstSize(pburst).build());
            return this;
        }

        public Builder setSession() {
            this.type = UpfEntityType.SESSION_METER;
            return this;
        }

        public Builder setApplication() {
            this.type = UpfEntityType.APPLICATION_METER;
            return this;
        }

        public UpfMeter build() {
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"A meter type must be assigned");
            switch (this.type) {
                case SESSION_METER: {
                    Preconditions.checkArgument((!this.bands.containsKey((Object)Band.Type.MARK_YELLOW) ? 1 : 0) != 0, (Object)"Committed band can not be provided for session meter!");
                    break;
                }
                case APPLICATION_METER: {
                    Preconditions.checkArgument((this.bands.containsKey((Object)Band.Type.MARK_YELLOW) && this.bands.containsKey((Object)Band.Type.MARK_RED) || this.bands.isEmpty() ? 1 : 0) != 0, (Object)"Bands (committed and peak) must be provided together or not at all!");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid meter type, I should never reach this point");
                }
            }
            Preconditions.checkNotNull((Object)this.cellId, (Object)"Meter cell ID must be provided!");
            return new UpfMeter(this.cellId, this.bands, this.type);
        }
    }
}

