/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import java.util.Optional;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public class UpfProgrammableException
extends Exception {
    private final Type type;
    private final UpfEntityType entityType;

    public UpfProgrammableException(String message) {
        super(message);
        this.type = Type.UNKNOWN;
        this.entityType = null;
    }

    public UpfProgrammableException(String message, Type type) {
        super(message);
        this.type = type;
        this.entityType = null;
    }

    public UpfProgrammableException(String message, Type type, UpfEntityType entityType) {
        super(message);
        this.type = type;
        this.entityType = entityType;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<UpfEntityType> getEntityType() {
        return Optional.ofNullable(this.entityType);
    }

    public static enum Type {
        UNKNOWN,
        ENTITY_EXHAUSTED,
        ENTITY_OUT_OF_RANGE,
        UNSUPPORTED_OPERATION;

    }
}

