/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class UpfTerminationDownlink
implements UpfEntity {
    private final Ip4Address ueSessionId;
    private final byte applicationId;
    private final Integer ctrId;
    private final Byte trafficClass;
    private final Integer teid;
    private final Byte qfi;
    private final int appMeterIdx;
    private final boolean dropping;

    private UpfTerminationDownlink(Ip4Address ueSessionId, byte applicationId, Integer ctrId, Byte trafficClass, Integer teid, Byte qfi, int appMeterIdx, boolean dropping) {
        this.ueSessionId = ueSessionId;
        this.applicationId = applicationId;
        this.ctrId = ctrId;
        this.trafficClass = trafficClass;
        this.teid = teid;
        this.qfi = qfi;
        this.appMeterIdx = appMeterIdx;
        this.dropping = dropping;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpfTerminationDownlink that = (UpfTerminationDownlink)obj;
        return this.dropping == that.dropping && Objects.equals(this.ueSessionId, that.ueSessionId) && Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.ctrId, that.ctrId) && Objects.equals(this.trafficClass, that.trafficClass) && Objects.equals(this.teid, that.teid) && this.appMeterIdx == that.appMeterIdx && Objects.equals(this.qfi, that.qfi);
    }

    public int hashCode() {
        return Objects.hash(this.ueSessionId, this.applicationId, this.ctrId, this.trafficClass, this.teid, this.qfi, this.appMeterIdx, this.dropping);
    }

    public Ip4Address ueSessionId() {
        return this.ueSessionId;
    }

    public byte applicationId() {
        return this.applicationId;
    }

    public Integer counterId() {
        return this.ctrId;
    }

    public Byte trafficClass() {
        return this.trafficClass;
    }

    public Integer teid() {
        return this.teid;
    }

    public Byte qfi() {
        return this.qfi;
    }

    public boolean needsDropping() {
        return this.dropping;
    }

    public int appMeterIdx() {
        return this.appMeterIdx;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.TERMINATION_DOWNLINK;
    }

    public String toString() {
        return "UpfTerminationDL(" + this.matchString() + " -> " + this.actionString() + ")";
    }

    private String matchString() {
        return "Match(ue_addr=" + this.ueSessionId() + ", app_id=" + this.applicationId + ")";
    }

    private String actionString() {
        String fwd = "FWD";
        if (this.needsDropping()) {
            fwd = "DROP";
        }
        return "Action(" + fwd + ", teid=" + this.teid() + ", ctr_id=" + this.counterId() + ", qfi=" + this.qfi() + ", tc=" + this.trafficClass() + ", app_meter_idx=" + this.appMeterIdx() + ")";
    }

    public static class Builder {
        private Ip4Address ueSessionId = null;
        private Byte applicationId = null;
        private Integer ctrId = null;
        private Byte trafficClass = null;
        private Integer teid = null;
        private Byte qfi = null;
        private int appMeterIdx = 0;
        private boolean drop = false;

        public Builder withUeSessionId(Ip4Address ueSessionId) {
            this.ueSessionId = ueSessionId;
            return this;
        }

        public Builder withApplicationId(byte applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder withCounterId(int ctrId) {
            this.ctrId = ctrId;
            return this;
        }

        public Builder withTrafficClass(byte trafficClass) {
            this.trafficClass = trafficClass;
            return this;
        }

        public Builder withTeid(Integer teid) {
            this.teid = teid;
            return this;
        }

        public Builder withQfi(byte qfi) {
            this.qfi = qfi;
            return this;
        }

        public Builder needsDropping(boolean drop) {
            this.drop = drop;
            return this;
        }

        public Builder withAppMeterIdx(int appMeterIdx) {
            this.appMeterIdx = appMeterIdx;
            return this;
        }

        public UpfTerminationDownlink build() {
            Preconditions.checkNotNull((Object)this.ueSessionId, (Object)"UE session ID must be provided");
            if (this.applicationId == null) {
                this.applicationId = 0;
            }
            Preconditions.checkNotNull((Object)this.ctrId, (Object)"Counter ID must be provided");
            return new UpfTerminationDownlink(this.ueSessionId, this.applicationId, this.ctrId, this.trafficClass, this.teid, this.qfi, this.appMeterIdx, this.drop);
        }
    }
}

