/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flowobjective;

import com.google.common.annotations.Beta;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.flowobjective.ObjectiveContext;

@Beta
public interface Objective
extends Annotated {
    public static final boolean DEFAULT_PERMANENT = true;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final int DEFAULT_PRIORITY = 32768;
    public static final int MIN_PRIORITY = 0;
    public static final int MAX_PRIORITY = 65535;

    public int id();

    public int priority();

    public ApplicationId appId();

    public int timeout();

    public boolean permanent();

    public Operation op();

    public Optional<ObjectiveContext> context();

    public Builder copy();

    public static interface Builder {
        public Builder makeTemporary(int var1);

        public Builder makePermanent();

        public Builder fromApp(ApplicationId var1);

        public Builder withPriority(int var1);

        public Builder withAnnotations(Annotations var1);

        public Objective add();

        public Objective remove();

        public Objective add(ObjectiveContext var1);

        public Objective remove(ObjectiveContext var1);
    }

    public static enum Operation {
        ADD,
        REMOVE,
        ADD_TO_EXISTING,
        REMOVE_FROM_EXISTING,
        MODIFY,
        VERIFY;

    }
}

