/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import org.onlab.util.ByteArraySizeHashPrinter;
import org.onosproject.store.service.DocumentPath;

public final class NodeUpdate<V> {
    private Type type;
    private DocumentPath path;
    private V value;
    private long version = -1L;

    public Type type() {
        return this.type;
    }

    public DocumentPath path() {
        return this.path;
    }

    public V value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public <T> NodeUpdate<T> map(Function<V, T> valueMapper) {
        return NodeUpdate.newBuilder().withType(this.type).withValue(this.value == null ? null : (Object)valueMapper.apply(this.value)).withVersion(this.version).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.path, this.value, this.version});
    }

    public boolean equals(Object object) {
        if (object instanceof NodeUpdate) {
            NodeUpdate that = (NodeUpdate)object;
            return this.type == that.type && Objects.equals(this.path, that.path) && Objects.equals(this.value, that.value) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("path", (Object)this.path).add("value", this.value instanceof byte[] ? new ByteArraySizeHashPrinter((byte[])this.value) : this.value).add("version", this.version).toString();
    }

    public static <V> Builder<V> newBuilder() {
        return new Builder();
    }

    public static final class Builder<V> {
        private NodeUpdate<V> update = new NodeUpdate();

        public NodeUpdate<V> build() {
            this.validateInputs();
            return this.update;
        }

        public Builder<V> withType(Type type) {
            this.update.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder<V> withPath(DocumentPath key) {
            this.update.path = (DocumentPath)Preconditions.checkNotNull((Object)key, (Object)"key cannot be null");
            return this;
        }

        public Builder<V> withValue(V value) {
            this.update.value = value;
            return this;
        }

        public Builder<V> withVersion(long version) {
            this.update.version = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull((Object)((Object)this.update.type), (Object)"type must be specified");
            switch (this.update.type) {
                case CREATE_NODE: {
                    Preconditions.checkNotNull((Object)this.update.path, (Object)"key must be specified");
                    Preconditions.checkNotNull(this.update.value, (Object)"value must be specified.");
                    break;
                }
                case UPDATE_NODE: {
                    Preconditions.checkNotNull((Object)this.update.path, (Object)"key must be specified");
                    Preconditions.checkNotNull(this.update.value, (Object)"value must be specified.");
                    Preconditions.checkState((this.update.version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                case DELETE_NODE: {
                    Preconditions.checkNotNull((Object)this.update.path, (Object)"key must be specified");
                    Preconditions.checkState((this.update.version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }

    public static enum Type {
        CREATE_NODE,
        UPDATE_NODE,
        DELETE_NODE;

    }
}

