/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.lion;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LionUtils {
    private static final Logger log = LoggerFactory.getLogger(LionUtils.class);
    private static final String USER_LANGUAGE = "user.language";
    private static final String USER_COUNTRY = "user.country";
    private static final String ONOS_LOCALE = "ONOS_LOCALE";
    private static final String EMPTY = "";
    private static final String DOT = ".";
    private static final String LOBAR = "_";

    private LionUtils() {
    }

    public static Locale localeFromString(String s) {
        if (!s.contains(LOBAR)) {
            return new Locale(s);
        }
        String[] items = s.split(LOBAR);
        return new Locale(items[0], items[1]);
    }

    public static Locale setupRuntimeLocale() {
        Locale systemDefault = Locale.getDefault();
        log.info("System Default Locale: [{}]", (Object)systemDefault);
        HashSet<String> pn = new HashSet<String>(System.getProperties().stringPropertyNames());
        pn.removeIf(f -> !f.startsWith("user."));
        for (String ukey : pn) {
            log.debug("  {}: {}", (Object)ukey, (Object)System.getProperty(ukey));
        }
        String language = System.getProperty(USER_LANGUAGE);
        String country = System.getProperty(USER_COUNTRY);
        log.info("Language: [{}], Country: [{}]", (Object)language, (Object)country);
        Locale runtime = new Locale(language != null ? language : EMPTY, country != null ? country : EMPTY);
        String override = System.getenv(ONOS_LOCALE);
        if (override != null) {
            log.warn("Override with ONOS_LOCALE: [{}]", (Object)override);
            runtime = LionUtils.localeFromString(override);
        }
        log.info("Setting runtime locale to: [{}]", (Object)runtime);
        Locale.setDefault(runtime);
        return runtime;
    }

    public static ResourceBundle getBundledResource(String basename) {
        return ResourceBundle.getBundle(basename, new UTF8Control());
    }

    public static ResourceBundle getBundledResource(String basename, Locale locale, ClassLoader classLoader) {
        return ResourceBundle.getBundle(basename, locale, classLoader, new UTF8Control());
    }

    public static ResourceBundle getBundledResource(Class<?> c) {
        return ResourceBundle.getBundle(c.getName(), new UTF8Control());
    }

    public static ResourceBundle getBundledResource(Class<?> c, String baseName) {
        String className = c.getName();
        StringBuilder sb = new StringBuilder();
        int dot = className.lastIndexOf(DOT);
        sb.append(className.substring(0, dot));
        sb.append(DOT).append(baseName);
        return ResourceBundle.getBundle(sb.toString(), new UTF8Control());
    }

    private static class UTF8Control
    extends ResourceBundle.Control {
        private static final String PROPERTIES = "properties";
        private static final String UTF_8 = "UTF-8";

        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, PROPERTIES);
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, UTF_8));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

