/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.event.AbstractEvent;

public class ClusterEvent
extends AbstractEvent<Type, ControllerNode> {
    private final InstanceType instanceType;

    public ClusterEvent(Type type, ControllerNode instance) {
        this(type, instance, InstanceType.UNKNOWN);
    }

    public ClusterEvent(Type type, ControllerNode instance, long time) {
        this(type, instance, time, InstanceType.UNKNOWN);
    }

    public ClusterEvent(Type type, ControllerNode instance, InstanceType instanceType) {
        super(type, instance);
        this.instanceType = instanceType;
    }

    public ClusterEvent(Type type, ControllerNode instance, long time, InstanceType instanceType) {
        super(type, instance, time);
        this.instanceType = instanceType;
    }

    public InstanceType instanceType() {
        return this.instanceType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type(), this.subject(), this.time(), this.instanceType()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClusterEvent) {
            ClusterEvent other = (ClusterEvent)obj;
            return Objects.equals(this.type(), other.type()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.time(), other.time()) && Objects.equals((Object)this.instanceType(), (Object)other.instanceType());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", this.type()).add("subject", this.subject()).add("time", this.time()).add("instanceType", (Object)this.instanceType()).toString();
    }

    public static enum InstanceType {
        ONOS,
        STORAGE,
        UNKNOWN;

    }

    public static enum Type {
        INSTANCE_ADDED,
        INSTANCE_REMOVED,
        INSTANCE_ACTIVATED,
        INSTANCE_READY,
        INSTANCE_DEACTIVATED;

    }
}

