/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.AbstractProjectableModel;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Link;
import org.onosproject.net.provider.ProviderId;

public class DefaultLink
extends AbstractProjectableModel
implements Link {
    private final ConnectPoint src;
    private final ConnectPoint dst;
    private final Link.Type type;
    private final Link.State state;
    private final boolean isExpected;

    protected DefaultLink(ProviderId providerId, ConnectPoint src, ConnectPoint dst, Link.Type type, Link.State state, Annotations ... annotations) {
        this(providerId, src, dst, type, state, false, annotations);
    }

    private DefaultLink(ProviderId providerId, ConnectPoint src, ConnectPoint dst, Link.Type type, Link.State state, boolean isExpected, Annotations ... annotations) {
        super(providerId, annotations);
        this.src = src;
        this.dst = dst;
        this.type = type;
        this.state = state;
        this.isExpected = isExpected;
    }

    @Override
    public ConnectPoint src() {
        return this.src;
    }

    @Override
    public ConnectPoint dst() {
        return this.dst;
    }

    @Override
    public Link.Type type() {
        return this.type;
    }

    @Override
    public Link.State state() {
        return this.state;
    }

    @Override
    public boolean isExpected() {
        return this.isExpected;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.src, this.dst, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultLink) {
            DefaultLink other = (DefaultLink)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.isExpected, other.isExpected);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("src", (Object)this.src).add("dst", (Object)this.dst).add("type", (Object)this.type).add("state", (Object)this.state).add("expected", this.isExpected).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ProviderId providerId;
        private Annotations annotations = DefaultAnnotations.EMPTY;
        private ConnectPoint src;
        private ConnectPoint dst;
        private Link.Type type;
        private Link.State state = Link.State.ACTIVE;
        private boolean isExpected = false;

        protected Builder() {
        }

        public Builder providerId(ProviderId providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder annotations(Annotations annotations) {
            this.annotations = annotations;
            return this;
        }

        public Builder src(ConnectPoint src) {
            this.src = src;
            return this;
        }

        public Builder dst(ConnectPoint dst) {
            this.dst = dst;
            return this;
        }

        public Builder type(Link.Type type) {
            this.type = type;
            return this;
        }

        public Builder state(Link.State state) {
            this.state = state;
            return this;
        }

        public Builder isExpected(boolean isExpected) {
            this.isExpected = isExpected;
            return this;
        }

        public DefaultLink build() {
            Preconditions.checkNotNull((Object)this.src, (Object)"Source connect point cannot be null");
            Preconditions.checkNotNull((Object)this.dst, (Object)"Destination connect point cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.type), (Object)"Type cannot be null");
            Preconditions.checkNotNull((Object)this.providerId, (Object)"Provider Id cannot be null");
            return new DefaultLink(this.providerId, this.src, this.dst, this.type, this.state, this.isExpected, this.annotations);
        }
    }
}

