/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onosproject.net.behaviour.upf.UpfEntity;
import org.onosproject.net.behaviour.upf.UpfEntityType;

@Beta
public final class UpfSessionUplink
implements UpfEntity {
    private final Ip4Address tunDestAddr;
    private final Integer teid;
    private final boolean dropping;
    private final int sessionMeterIdx;

    private UpfSessionUplink(Ip4Address tunDestAddr, Integer teid, int sessionMeterIdx, boolean drop) {
        this.tunDestAddr = tunDestAddr;
        this.teid = teid;
        this.sessionMeterIdx = sessionMeterIdx;
        this.dropping = drop;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UpfSessionUplink that = (UpfSessionUplink)object;
        return this.dropping == that.dropping && this.sessionMeterIdx == that.sessionMeterIdx && Objects.equals(this.tunDestAddr, that.tunDestAddr) && Objects.equals(this.teid, that.teid);
    }

    public int hashCode() {
        return Objects.hash(this.tunDestAddr, this.teid, this.sessionMeterIdx, this.dropping);
    }

    public String toString() {
        return "UpfSessionUL(" + this.matchString() + " -> " + this.actionString() + ")";
    }

    private String matchString() {
        return "Match(tun_dst_addr=" + this.tunDstAddr() + ", teid=" + this.teid() + ")";
    }

    private String actionString() {
        StringBuilder actionStrBuilder = new StringBuilder("Action(");
        if (this.needsDropping()) {
            actionStrBuilder.append("DROP");
        } else {
            actionStrBuilder.append("FWD");
        }
        return actionStrBuilder.append(", session_meter_idx=").append(this.sessionMeterIdx()).append(")").toString();
    }

    public boolean needsDropping() {
        return this.dropping;
    }

    public Ip4Address tunDstAddr() {
        return this.tunDestAddr;
    }

    public Integer teid() {
        return this.teid;
    }

    public int sessionMeterIdx() {
        return this.sessionMeterIdx;
    }

    @Override
    public UpfEntityType type() {
        return UpfEntityType.SESSION_UPLINK;
    }

    public static class Builder {
        private Ip4Address tunDstAddr = null;
        private Integer teid = null;
        public int sessionMeterIdx = 0;
        private boolean drop = false;

        public Builder withTunDstAddr(Ip4Address tunDstAddr) {
            this.tunDstAddr = tunDstAddr;
            return this;
        }

        public Builder withTeid(Integer teid) {
            this.teid = teid;
            return this;
        }

        public Builder needsDropping(boolean drop) {
            this.drop = drop;
            return this;
        }

        public Builder withSessionMeterIdx(int sessionMeterIdx) {
            this.sessionMeterIdx = sessionMeterIdx;
            return this;
        }

        public UpfSessionUplink build() {
            Preconditions.checkNotNull((Object)this.tunDstAddr, (Object)"Tunnel destination must be provided");
            Preconditions.checkNotNull((Object)this.teid, (Object)"TEID must be provided");
            return new UpfSessionUplink(this.tunDstAddr, this.teid, this.sessionMeterIdx, this.drop);
        }
    }
}

