/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.collect.Iterables;
import org.onosproject.core.ApplicationId;
import org.onosproject.event.ListenerService;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleEvent;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.FlowRuleOperations;
import org.onosproject.net.flow.TableStatisticsEntry;

public interface FlowRuleService
extends ListenerService<FlowRuleEvent, FlowRuleListener> {
    public static final String FLOW_OP_TOPIC = "flow-ops-ids";

    public int getFlowRuleCount();

    default public int getFlowRuleCount(DeviceId deviceId) {
        return 0;
    }

    default public int getFlowRuleCount(DeviceId deviceId, FlowEntry.FlowEntryState state) {
        return 0;
    }

    public FlowEntry getFlowEntry(FlowRule var1);

    public Iterable<FlowEntry> getFlowEntries(DeviceId var1);

    default public Iterable<FlowEntry> getFlowEntriesByLiveType(DeviceId deviceId, FlowEntry.FlowLiveType liveType) {
        return Iterables.filter(this.getFlowEntries(deviceId), fe -> fe.liveType() == liveType);
    }

    default public Iterable<FlowEntry> getFlowEntriesByState(DeviceId deviceId, FlowEntry.FlowEntryState flowState) {
        return Iterables.filter(this.getFlowEntries(deviceId), fe -> fe.state() == flowState);
    }

    public void applyFlowRules(FlowRule ... var1);

    public void purgeFlowRules(DeviceId var1);

    default public void purgeFlowRules(DeviceId deviceId, ApplicationId appId) {
        throw new UnsupportedOperationException("purgeFlowRules not implemented!");
    }

    public void removeFlowRules(FlowRule ... var1);

    public void removeFlowRulesById(ApplicationId var1);

    public Iterable<FlowEntry> getFlowEntriesById(ApplicationId var1);

    public Iterable<FlowRule> getFlowRulesByGroupId(ApplicationId var1, short var2);

    public void apply(FlowRuleOperations var1);

    public Iterable<TableStatisticsEntry> getFlowTableStatistics(DeviceId var1);

    @Deprecated
    default public long getActiveFlowRuleCount(DeviceId deviceId) {
        return 0L;
    }
}

