/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Optional;
import java.util.StringJoiner;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.runtime.PiExactFieldMatch;
import org.onosproject.net.pi.runtime.PiFieldMatch;
import org.onosproject.net.pi.runtime.PiLpmFieldMatch;
import org.onosproject.net.pi.runtime.PiOptionalFieldMatch;
import org.onosproject.net.pi.runtime.PiRangeFieldMatch;
import org.onosproject.net.pi.runtime.PiTernaryFieldMatch;

@Beta
public final class PiCriterion
implements Criterion {
    private final ImmutableMap<PiMatchFieldId, PiFieldMatch> fieldMatchMap;

    private PiCriterion(ImmutableMap<PiMatchFieldId, PiFieldMatch> fieldMatchMap) {
        this.fieldMatchMap = fieldMatchMap;
    }

    public Collection<PiFieldMatch> fieldMatches() {
        return this.fieldMatchMap.values();
    }

    public Optional<PiFieldMatch> fieldMatch(PiMatchFieldId fieldId) {
        return Optional.ofNullable((PiFieldMatch)this.fieldMatchMap.get((Object)fieldId));
    }

    @Override
    public Criterion.Type type() {
        return Criterion.Type.PROTOCOL_INDEPENDENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PiCriterion that = (PiCriterion)o;
        return Objects.equal(this.fieldMatchMap, that.fieldMatchMap);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fieldMatchMap});
    }

    public String toString() {
        StringJoiner stringParams = new StringJoiner(", ");
        this.fieldMatchMap.forEach((key, value) -> stringParams.add(value.toString()));
        return stringParams.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PiCriterion piCriterion) {
        return new Builder(piCriterion);
    }

    @Beta
    public static final class Builder {
        private final ImmutableMap.Builder<PiMatchFieldId, PiFieldMatch> fieldMatchMapBuilder = ImmutableMap.builder();

        private Builder() {
        }

        private Builder(PiCriterion piCriterion) {
            piCriterion.fieldMatchMap.forEach((piMatchFieldId, piFieldMatch) -> this.add((PiFieldMatch)piFieldMatch));
        }

        public Builder add(PiFieldMatch field) {
            this.fieldMatchMapBuilder.put((Object)field.fieldId(), (Object)field);
            return this;
        }

        public Builder matchExact(PiMatchFieldId fieldId, short value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiExactFieldMatch(fieldId, ImmutableByteSequence.copyFrom((short)value)));
            return this;
        }

        public Builder matchExact(PiMatchFieldId fieldId, int value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiExactFieldMatch(fieldId, ImmutableByteSequence.copyFrom((int)value)));
            return this;
        }

        public Builder matchExact(PiMatchFieldId fieldId, long value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiExactFieldMatch(fieldId, ImmutableByteSequence.copyFrom((long)value)));
            return this;
        }

        public Builder matchExact(PiMatchFieldId fieldId, byte[] value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiExactFieldMatch(fieldId, ImmutableByteSequence.copyFrom((byte[])value)));
            return this;
        }

        public Builder matchExact(PiMatchFieldId fieldId, String value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiExactFieldMatch(fieldId, ImmutableByteSequence.copyFrom((String)value)));
            return this;
        }

        public Builder matchTernary(PiMatchFieldId fieldId, short value, short mask) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiTernaryFieldMatch(fieldId, ImmutableByteSequence.copyFrom((short)value), ImmutableByteSequence.copyFrom((short)mask)));
            return this;
        }

        public Builder matchTernary(PiMatchFieldId fieldId, int value, int mask) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiTernaryFieldMatch(fieldId, ImmutableByteSequence.copyFrom((int)value), ImmutableByteSequence.copyFrom((int)mask)));
            return this;
        }

        public Builder matchTernary(PiMatchFieldId fieldId, long value, long mask) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiTernaryFieldMatch(fieldId, ImmutableByteSequence.copyFrom((long)value), ImmutableByteSequence.copyFrom((long)mask)));
            return this;
        }

        public Builder matchTernary(PiMatchFieldId fieldId, byte[] value, byte[] mask) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiTernaryFieldMatch(fieldId, ImmutableByteSequence.copyFrom((byte[])value), ImmutableByteSequence.copyFrom((byte[])mask)));
            return this;
        }

        public Builder matchLpm(PiMatchFieldId fieldId, short value, int prefixLength) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiLpmFieldMatch(fieldId, ImmutableByteSequence.copyFrom((short)value), prefixLength));
            return this;
        }

        public Builder matchLpm(PiMatchFieldId fieldId, int value, int prefixLength) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiLpmFieldMatch(fieldId, ImmutableByteSequence.copyFrom((int)value), prefixLength));
            return this;
        }

        public Builder matchLpm(PiMatchFieldId fieldId, long value, int prefixLength) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiLpmFieldMatch(fieldId, ImmutableByteSequence.copyFrom((long)value), prefixLength));
            return this;
        }

        public Builder matchLpm(PiMatchFieldId fieldId, byte[] value, int prefixLength) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiLpmFieldMatch(fieldId, ImmutableByteSequence.copyFrom((byte[])value), prefixLength));
            return this;
        }

        public Builder matchRange(PiMatchFieldId fieldId, short low, short high) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiRangeFieldMatch(fieldId, ImmutableByteSequence.copyFrom((short)low), ImmutableByteSequence.copyFrom((short)high)));
            return this;
        }

        public Builder matchRange(PiMatchFieldId fieldId, int low, int high) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiRangeFieldMatch(fieldId, ImmutableByteSequence.copyFrom((int)low), ImmutableByteSequence.copyFrom((int)high)));
            return this;
        }

        public Builder matchRange(PiMatchFieldId fieldId, long low, long high) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiRangeFieldMatch(fieldId, ImmutableByteSequence.copyFrom((long)low), ImmutableByteSequence.copyFrom((long)high)));
            return this;
        }

        public Builder matchRange(PiMatchFieldId fieldId, byte[] low, byte[] high) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiRangeFieldMatch(fieldId, ImmutableByteSequence.copyFrom((byte[])low), ImmutableByteSequence.copyFrom((byte[])high)));
            return this;
        }

        public Builder matchOptional(PiMatchFieldId fieldId, short value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiOptionalFieldMatch(fieldId, ImmutableByteSequence.copyFrom((short)value)));
            return this;
        }

        public Builder matchOptional(PiMatchFieldId fieldId, int value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiOptionalFieldMatch(fieldId, ImmutableByteSequence.copyFrom((int)value)));
            return this;
        }

        public Builder matchOptional(PiMatchFieldId fieldId, long value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiOptionalFieldMatch(fieldId, ImmutableByteSequence.copyFrom((long)value)));
            return this;
        }

        public Builder matchOptional(PiMatchFieldId fieldId, byte[] value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiOptionalFieldMatch(fieldId, ImmutableByteSequence.copyFrom((byte[])value)));
            return this;
        }

        public Builder matchOptional(PiMatchFieldId fieldId, String value) {
            this.fieldMatchMapBuilder.put((Object)fieldId, (Object)new PiOptionalFieldMatch(fieldId, ImmutableByteSequence.copyFrom((String)value)));
            return this;
        }

        public PiCriterion build() {
            ImmutableMap fieldMatchMap = this.fieldMatchMapBuilder.build();
            Preconditions.checkArgument((fieldMatchMap.size() > 0 ? 1 : 0) != 0, (Object)"Cannot build PI criterion with 0 field matches");
            return new PiCriterion((ImmutableMap<PiMatchFieldId, PiFieldMatch>)fieldMatchMap);
        }
    }
}

