/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.AbstractAnnotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterContext;
import org.onosproject.net.meter.MeterRequest;
import org.onosproject.net.meter.MeterScope;

public final class DefaultMeterRequest
extends AbstractAnnotated
implements MeterRequest {
    private final ApplicationId appId;
    private final Meter.Unit unit;
    private final boolean burst;
    private final Collection<Band> bands;
    private final DeviceId deviceId;
    private final Optional<MeterContext> context;
    private final MeterRequest.Type op;
    private final MeterScope scope;
    private final Optional<Long> index;

    private DefaultMeterRequest(DeviceId deviceId, ApplicationId appId, Meter.Unit unit, boolean burst, Collection<Band> bands, MeterContext context, MeterRequest.Type op, MeterScope scope, Optional<Long> index, Annotations ... annotations) {
        super(annotations);
        this.deviceId = deviceId;
        this.appId = appId;
        this.unit = unit;
        this.burst = burst;
        this.bands = bands;
        this.context = Optional.ofNullable(context);
        this.op = op;
        this.scope = scope;
        this.index = index;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public ApplicationId appId() {
        return this.appId;
    }

    @Override
    public Meter.Unit unit() {
        return this.unit;
    }

    @Override
    public boolean isBurst() {
        return this.burst;
    }

    @Override
    public Collection<Band> bands() {
        return this.bands;
    }

    @Override
    public Optional<MeterContext> context() {
        return this.context;
    }

    @Override
    public MeterScope scope() {
        return this.scope;
    }

    @Override
    public Optional<Long> index() {
        return this.index;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("device", (Object)this.deviceId).add("appId", (Object)this.appId.name()).add("unit", (Object)this.unit).add("isBurst", this.burst).add("bands", this.bands).add("scope", (Object)this.scope).add("desired index", this.index.orElse(null)).add("annotations", (Object)this.annotations()).toString();
    }

    public static final class Builder
    implements MeterRequest.Builder {
        private static final Band DUMMY_BAND = new DefaultBand(Band.Type.DROP, 0L, 0L, (short)0);
        private ApplicationId appId;
        private Meter.Unit unit = Meter.Unit.KB_PER_SEC;
        private boolean burst = false;
        private Collection<Band> bands;
        private DeviceId deviceId;
        private MeterContext context;
        private Annotations annotations;
        private MeterScope scope = MeterScope.globalScope();
        private Optional<Long> desiredIndex = Optional.empty();

        @Override
        public MeterRequest.Builder forDevice(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public MeterRequest.Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public MeterRequest.Builder withUnit(Meter.Unit unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public MeterRequest.Builder burst() {
            this.burst = true;
            return this;
        }

        @Override
        public MeterRequest.Builder withBands(Collection<Band> bands) {
            this.bands = ImmutableSet.copyOf(bands);
            return this;
        }

        @Override
        public MeterRequest.Builder withContext(MeterContext context) {
            this.context = context;
            return this;
        }

        @Override
        public MeterRequest.Builder withAnnotations(Annotations annotations) {
            this.annotations = annotations;
            return this;
        }

        @Override
        public MeterRequest.Builder withScope(MeterScope scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public MeterRequest.Builder withIndex(Long index) {
            this.desiredIndex = Optional.ofNullable(index);
            return this;
        }

        @Override
        public MeterRequest add() {
            this.validate();
            return new DefaultMeterRequest(this.deviceId, this.appId, this.unit, this.burst, this.bands, this.context, MeterRequest.Type.ADD, this.scope, this.desiredIndex, this.annotations);
        }

        @Override
        public MeterRequest remove() {
            if (this.bands == null || this.bands.isEmpty()) {
                this.bands = ImmutableSet.of((Object)DUMMY_BAND);
            }
            this.validate();
            return new DefaultMeterRequest(this.deviceId, this.appId, this.unit, this.burst, this.bands, this.context, MeterRequest.Type.REMOVE, this.scope, this.desiredIndex, this.annotations);
        }

        private void validate() {
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must specify a device");
            Preconditions.checkNotNull(this.bands, (Object)"Must have bands.");
            Preconditions.checkArgument((!this.bands.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one band.");
            Preconditions.checkNotNull((Object)this.appId, (Object)"Must have an application id");
            if (this.desiredIndex.isPresent()) {
                Preconditions.checkArgument((this.desiredIndex.get() >= 0L ? 1 : 0) != 0, (Object)"Desired index cannot be negative");
            }
        }
    }
}

