/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.onosproject.cluster.Leadership;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Change;
import org.onosproject.store.service.AsyncLeaderElector;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.LeaderElector;
import org.onosproject.store.service.StorageException;
import org.onosproject.store.service.Synchronous;

public class DefaultLeaderElector
extends Synchronous<AsyncLeaderElector>
implements LeaderElector {
    private final AsyncLeaderElector asyncElector;
    private final long operationTimeoutMillis;

    public DefaultLeaderElector(AsyncLeaderElector asyncElector, long operationTimeoutMillis) {
        super(asyncElector);
        this.asyncElector = asyncElector;
        this.operationTimeoutMillis = operationTimeoutMillis;
    }

    @Override
    public Leadership run(String topic, NodeId nodeId) {
        return this.complete(this.asyncElector.run(topic, nodeId));
    }

    @Override
    public void withdraw(String topic) {
        this.complete(this.asyncElector.withdraw(topic));
    }

    @Override
    public boolean anoint(String topic, NodeId nodeId) {
        return this.complete(this.asyncElector.anoint(topic, nodeId));
    }

    @Override
    public boolean promote(String topic, NodeId nodeId) {
        return this.complete(this.asyncElector.promote(topic, nodeId));
    }

    @Override
    public void evict(NodeId nodeId) {
        this.complete(this.asyncElector.evict(nodeId));
    }

    @Override
    public Leadership getLeadership(String topic) {
        return this.complete(this.asyncElector.getLeadership(topic));
    }

    @Override
    public Map<String, Leadership> getLeaderships() {
        return this.complete(this.asyncElector.getLeaderships());
    }

    @Override
    public void addChangeListener(Consumer<Change<Leadership>> consumer) {
        this.complete(this.asyncElector.addChangeListener(consumer));
    }

    @Override
    public void removeChangeListener(Consumer<Change<Leadership>> consumer) {
        this.complete(this.asyncElector.removeChangeListener(consumer));
    }

    @Override
    public boolean demote(String topic, NodeId nodeId) {
        return this.complete(this.asyncElector.demote(topic, nodeId));
    }

    @Override
    public void addStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.asyncElector.addStatusChangeListener(listener);
    }

    @Override
    public void removeStatusChangeListener(Consumer<DistributedPrimitive.Status> listener) {
        this.asyncElector.removeStatusChangeListener(listener);
    }

    @Override
    public Collection<Consumer<DistributedPrimitive.Status>> statusChangeListeners() {
        return this.asyncElector.statusChangeListeners();
    }

    private <T> T complete(CompletableFuture<T> future) {
        try {
            return future.get(this.operationTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException.Interrupted();
        }
        catch (TimeoutException e) {
            throw new StorageException.Timeout();
        }
        catch (ExecutionException e) {
            throw new StorageException(e.getCause());
        }
    }
}

