/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.mastership;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipInfo;
import org.onosproject.net.MastershipRole;

public class MastershipInfoTest {
    private final NodeId node1 = new NodeId("1");
    private final NodeId node2 = new NodeId("2");
    private final NodeId node3 = new NodeId("3");
    private final NodeId node4 = new NodeId("4");
    private final MastershipInfo mastershipInfo = new MastershipInfo(1L, Optional.of(this.node1), ImmutableMap.builder().put((Object)this.node1, (Object)MastershipRole.MASTER).put((Object)this.node2, (Object)MastershipRole.STANDBY).put((Object)this.node3, (Object)MastershipRole.STANDBY).put((Object)this.node4, (Object)MastershipRole.NONE).build());

    @Test
    public void testMastershipInfo() throws Exception {
        Assert.assertEquals((long)1L, (long)this.mastershipInfo.term());
        Assert.assertEquals((Object)this.node1, this.mastershipInfo.master().get());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new NodeId[]{this.node1}), (Object)this.mastershipInfo.getRoles(MastershipRole.MASTER));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new NodeId[]{this.node2, this.node3}), (Object)this.mastershipInfo.backups());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new NodeId[]{this.node2, this.node3}), (Object)this.mastershipInfo.getRoles(MastershipRole.STANDBY));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new NodeId[]{this.node4}), (Object)this.mastershipInfo.getRoles(MastershipRole.NONE));
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)this.mastershipInfo, (Object)this.mastershipInfo);
        Assert.assertNotEquals((Object)this.mastershipInfo, (Object)new MastershipInfo(1L, Optional.of(this.node1), ImmutableMap.of()));
    }
}

