/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiMatchFieldId;
import org.onosproject.net.pi.model.PiMatchType;
import org.onosproject.net.pi.runtime.PiOptionalFieldMatch;

public class PiOptionalFieldMatchTest {
    private final ImmutableByteSequence value1 = ImmutableByteSequence.copyFrom((int)2048);
    private final ImmutableByteSequence value2 = ImmutableByteSequence.copyFrom((int)2054);
    private final PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ethernet_t.etherType");
    private PiOptionalFieldMatch piOptionalFieldMatch1 = new PiOptionalFieldMatch(this.piMatchField, this.value1);
    private PiOptionalFieldMatch sameAsPiOptionalFieldMatch1 = new PiOptionalFieldMatch(this.piMatchField, this.value1);
    private PiOptionalFieldMatch piOptionalFieldMatch2 = new PiOptionalFieldMatch(this.piMatchField, this.value2);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiOptionalFieldMatch.class);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.piOptionalFieldMatch1, this.sameAsPiOptionalFieldMatch1}).addEqualityGroup(new Object[]{this.piOptionalFieldMatch2}).testEquals();
    }

    @Test
    public void testConstruction() {
        ImmutableByteSequence value = ImmutableByteSequence.copyFrom((int)2054);
        PiMatchFieldId piMatchField = PiMatchFieldId.of((String)"ethernet_t.etherType");
        PiOptionalFieldMatch piOptionalFieldMatch = new PiOptionalFieldMatch(piMatchField, value);
        MatcherAssert.assertThat((Object)piOptionalFieldMatch, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)piOptionalFieldMatch.value(), (Matcher)Matchers.is((Object)value));
        MatcherAssert.assertThat((Object)piOptionalFieldMatch.type(), (Matcher)Matchers.is((Object)PiMatchType.OPTIONAL));
    }
}

