/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onlab.util.ImmutableByteSequence;

public final class GtpTunnel {
    private final Ip4Address src;
    private final Ip4Address dst;
    private final ImmutableByteSequence teid;
    private final short srcPort;

    private GtpTunnel(Ip4Address src, Ip4Address dst, ImmutableByteSequence teid, Short srcPort) {
        this.src = src;
        this.dst = dst;
        this.teid = teid;
        this.srcPort = srcPort;
    }

    public static GtpTunnelBuilder builder() {
        return new GtpTunnelBuilder();
    }

    public String toString() {
        return String.format("GTP-Tunnel(%s -> %s, TEID:%s)", this.src.toString(), this.dst.toString(), this.teid.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GtpTunnel that = (GtpTunnel)obj;
        return this.src.equals((Object)that.src) && this.dst.equals((Object)that.dst) && this.teid.equals((Object)that.teid) && this.srcPort == that.srcPort;
    }

    public int hashCode() {
        return Objects.hash(this.src, this.dst, this.teid, this.srcPort);
    }

    public Ip4Address src() {
        return this.src;
    }

    public Ip4Address dst() {
        return this.dst;
    }

    public ImmutableByteSequence teid() {
        return this.teid;
    }

    public Short srcPort() {
        return this.srcPort;
    }

    public static class GtpTunnelBuilder {
        private Ip4Address src = null;
        private Ip4Address dst = null;
        private ImmutableByteSequence teid = null;
        private short srcPort = (short)2152;

        public GtpTunnelBuilder setSrc(Ip4Address src) {
            this.src = src;
            return this;
        }

        public GtpTunnelBuilder setDst(Ip4Address dst) {
            this.dst = dst;
            return this;
        }

        public GtpTunnelBuilder setTeid(ImmutableByteSequence teid) {
            this.teid = teid;
            return this;
        }

        public GtpTunnelBuilder setTeid(long teid) {
            this.teid = ImmutableByteSequence.copyFrom((long)teid);
            return this;
        }

        public GtpTunnelBuilder setSrcPort(short srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        public GtpTunnel build() {
            Preconditions.checkNotNull((Object)this.src, (Object)"Tunnel source address cannot be null");
            Preconditions.checkNotNull((Object)this.dst, (Object)"Tunnel destination address cannot be null");
            Preconditions.checkNotNull((Object)this.teid, (Object)"Tunnel TEID cannot be null");
            return new GtpTunnel(this.src, this.dst, this.teid, this.srcPort);
        }
    }
}

