/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.VlanId;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.resource.DiscreteResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.Resources;

public class DiscreteResourceTest {
    private static final DeviceId D1 = DeviceId.deviceId((String)"of:001");
    private static final DeviceId D2 = DeviceId.deviceId((String)"of:002");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final VlanId VLAN1 = VlanId.vlanId((short)100);
    private static final Bandwidth BW1 = Bandwidth.gbps((long)2L);

    @Test
    public void testEquals() {
        DiscreteResource resource1 = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        DiscreteResource sameAsResource1 = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        DiscreteResource resource2 = Resources.discrete((DeviceId)D2, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        new EqualsTester().addEqualityGroup(new Object[]{resource1, sameAsResource1}).addEqualityGroup(new Object[]{resource2}).testEquals();
    }

    @Test
    public void testChild() {
        DiscreteResource r1 = Resources.discrete((DeviceId)D1).resource().child((Object)P1);
        DiscreteResource sameAsR2 = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[0]).resource();
        Assert.assertThat((Object)r1, (Matcher)Matchers.is((Object)sameAsR2));
    }

    @Test
    public void testThereIsParent() {
        DiscreteResource resource = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        DiscreteResource parent = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[0]).resource();
        Assert.assertThat((Object)resource.parent(), (Matcher)Matchers.is(Optional.of(parent)));
    }

    @Test
    public void testNoParent() {
        DiscreteResource resource = Resources.discrete((DeviceId)D1).resource();
        Assert.assertThat((Object)resource.parent(), (Matcher)Matchers.is(Optional.of(Resource.ROOT)));
    }

    @Test
    public void testTypeOf() {
        DiscreteResource discrete = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        Assert.assertThat((Object)discrete.isTypeOf(DeviceId.class), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)discrete.isTypeOf(PortNumber.class), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)discrete.isTypeOf(VlanId.class), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testSubTypeOf() {
        DiscreteResource discrete = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        Assert.assertThat((Object)discrete.isSubTypeOf(DeviceId.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)discrete.isSubTypeOf(PortNumber.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)discrete.isSubTypeOf(VlanId.class), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)discrete.isSubTypeOf(Bandwidth.class), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSubTypeOfObject() {
        DiscreteResource discrete = Resources.discrete((DeviceId)D1, (PortNumber)P1, (Object[])new Object[]{VLAN1}).resource();
        Assert.assertThat((Object)discrete.isSubTypeOf(Object.class), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testValueAs() {
        DiscreteResource resource = Resources.discrete((DeviceId)D1).resource();
        Optional volume = resource.valueAs(DeviceId.class);
        Assert.assertThat((Object)((DeviceId)volume.get()), (Matcher)Matchers.is((Object)D1));
    }

    @Test
    public void testValueOfRoot() {
        DiscreteResource resource = Resource.ROOT;
        Assert.assertThat((Object)resource.valueAs(Object.class), (Matcher)Matchers.is(Optional.empty()));
    }
}

