/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.onosproject.store.service.DistributedPrimitive;
import org.onosproject.store.service.Topic;

public class TestTopic<T>
implements Topic<T> {
    private final String name;
    private final Map<Consumer<T>, Executor> callbacks = Maps.newIdentityHashMap();

    public TestTopic(String name) {
        this.name = name;
    }

    public CompletableFuture<Void> publish(T message) {
        this.callbacks.forEach((k, v) -> v.execute(() -> k.accept(message)));
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> subscribe(Consumer<T> callback, Executor executor) {
        this.callbacks.put(callback, executor);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> unsubscribe(Consumer<T> callback) {
        this.callbacks.remove(callback);
        return CompletableFuture.completedFuture(null);
    }

    public String name() {
        return this.name;
    }

    public DistributedPrimitive.Type primitiveType() {
        return DistributedPrimitive.Type.TOPIC;
    }
}

