/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.behaviour.upf.GtpTunnel;

public final class ForwardingActionRule {
    private final ImmutableByteSequence sessionId;
    private final int farId;
    private final boolean notifyFlag;
    private final boolean dropFlag;
    private final boolean bufferFlag;
    private final GtpTunnel tunnel;
    private static final int SESSION_ID_BITWIDTH = 96;

    private ForwardingActionRule(ImmutableByteSequence sessionId, Integer farId, boolean notifyFlag, GtpTunnel tunnel, boolean dropFlag, boolean bufferFlag) {
        this.sessionId = sessionId;
        this.farId = farId;
        this.notifyFlag = notifyFlag;
        this.tunnel = tunnel;
        this.dropFlag = dropFlag;
        this.bufferFlag = bufferFlag;
    }

    public ForwardingActionRule withoutActionParams() {
        return ForwardingActionRule.builder().setFarId(this.farId).withSessionId(this.sessionId).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String actionString() {
        Object actionName;
        String actionParams = "";
        if (this.dropFlag) {
            actionName = "Drop";
        } else if (this.bufferFlag) {
            actionName = "Buffer";
        } else if (this.tunnel != null) {
            actionName = "Encap";
            actionParams = String.format("Src=%s, SPort=%d, TEID=%s, Dst=%s", this.tunnel.src().toString(), this.tunnel.srcPort(), this.tunnel.teid().toString(), this.tunnel.dst().toString());
        } else {
            actionName = "Forward";
        }
        if (this.notifyFlag) {
            actionName = (String)actionName + "+NotifyCP";
        }
        return String.format("%s(%s)", actionName, actionParams);
    }

    public String toString() {
        String matchKeys = String.format("ID=%d, SEID=%s", this.farId, this.sessionId.toString());
        String actionString = this.actionString();
        return String.format("FAR{Match(%s) -> %s}", matchKeys, actionString);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForwardingActionRule that = (ForwardingActionRule)obj;
        return this.dropFlag == that.dropFlag && this.bufferFlag == that.bufferFlag && this.notifyFlag == that.notifyFlag && this.farId == that.farId && Objects.equals(this.tunnel, that.tunnel) && Objects.equals(this.sessionId, that.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.farId, this.notifyFlag, this.tunnel, this.dropFlag, this.bufferFlag);
    }

    public ImmutableByteSequence sessionId() {
        return this.sessionId;
    }

    public int farId() {
        return this.farId;
    }

    public boolean forwards() {
        return !this.dropFlag;
    }

    public boolean encaps() {
        return this.tunnel != null;
    }

    public boolean drops() {
        return this.dropFlag;
    }

    public boolean notifies() {
        return this.notifyFlag;
    }

    public boolean buffers() {
        return this.bufferFlag;
    }

    public GtpTunnel tunnel() {
        return this.tunnel;
    }

    public Short tunnelSrcPort() {
        return this.tunnel != null ? this.tunnel.srcPort() : null;
    }

    public Ip4Address tunnelSrc() {
        if (this.tunnel == null) {
            return null;
        }
        return this.tunnel.src();
    }

    public Ip4Address tunnelDst() {
        if (this.tunnel == null) {
            return null;
        }
        return this.tunnel.dst();
    }

    public ImmutableByteSequence teid() {
        if (this.tunnel == null) {
            return null;
        }
        return this.tunnel.teid();
    }

    public static class Builder {
        private ImmutableByteSequence sessionId = null;
        private Integer farId = null;
        private GtpTunnel tunnel = null;
        private boolean dropFlag = false;
        private boolean bufferFlag = false;
        private boolean notifyCp = false;

        public Builder withSessionId(ImmutableByteSequence sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withSessionId(long sessionId) {
            try {
                this.sessionId = ImmutableByteSequence.copyFrom((long)sessionId).fit(96);
            }
            catch (ImmutableByteSequence.ByteSequenceTrimException byteSequenceTrimException) {
                // empty catch block
            }
            return this;
        }

        public Builder setFarId(int farId) {
            this.farId = farId;
            return this;
        }

        public Builder setForwardFlag(boolean flag) {
            this.dropFlag = !flag;
            return this;
        }

        public Builder setDropFlag(boolean flag) {
            this.dropFlag = flag;
            return this;
        }

        public Builder setBufferFlag(boolean flag) {
            this.bufferFlag = flag;
            return this;
        }

        public Builder setNotifyFlag(boolean notifyCp) {
            this.notifyCp = notifyCp;
            return this;
        }

        public Builder setTunnel(GtpTunnel tunnel) {
            this.tunnel = tunnel;
            return this;
        }

        public Builder setTunnel(Ip4Address src, Ip4Address dst, ImmutableByteSequence teid) {
            return this.setTunnel(GtpTunnel.builder().setSrc(src).setDst(dst).setTeid(teid).build());
        }

        public Builder setTunnel(Ip4Address src, Ip4Address dst, ImmutableByteSequence teid, short srcPort) {
            return this.setTunnel(GtpTunnel.builder().setSrc(src).setDst(dst).setTeid(teid).setSrcPort(srcPort).build());
        }

        public ForwardingActionRule build() {
            Preconditions.checkNotNull((Object)this.sessionId, (Object)"Session ID is required");
            Preconditions.checkNotNull((Object)this.farId, (Object)"FAR ID is required");
            return new ForwardingActionRule(this.sessionId, this.farId, this.notifyCp, this.tunnel, this.dropFlag, this.bufferFlag);
        }
    }
}

