/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiMulticastGroupEntryHandle;
import org.onosproject.net.pi.runtime.PiPreEntry;
import org.onosproject.net.pi.runtime.PiPreEntryType;
import org.onosproject.net.pi.runtime.PiPreReplica;

@Beta
public final class PiMulticastGroupEntry
implements PiPreEntry {
    private final int groupId;
    private final Set<PiPreReplica> replicas;

    private PiMulticastGroupEntry(int groupId, Set<PiPreReplica> replicas) {
        this.groupId = groupId;
        this.replicas = replicas;
    }

    public int groupId() {
        return this.groupId;
    }

    public Set<PiPreReplica> replicas() {
        return this.replicas;
    }

    @Override
    public PiPreEntryType preEntryType() {
        return PiPreEntryType.MULTICAST_GROUP;
    }

    @Override
    public PiEntityType piEntityType() {
        return PiEntityType.PRE_ENTRY;
    }

    @Override
    public PiMulticastGroupEntryHandle handle(DeviceId deviceId) {
        return PiMulticastGroupEntryHandle.of(deviceId, this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.replicas});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PiMulticastGroupEntry other = (PiMulticastGroupEntry)obj;
        return Objects.equal((Object)this.groupId, (Object)other.groupId) && Objects.equal(this.replicas, other.replicas);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupId", (Object)("0x" + Integer.toHexString(this.groupId))).add("replicas", this.replicas).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer groupId;
        private ImmutableSet.Builder<PiPreReplica> replicaSetBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public Builder withGroupId(int groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder addReplica(PiPreReplica replica) {
            Preconditions.checkNotNull((Object)replica);
            this.replicaSetBuilder.add((Object)replica);
            return this;
        }

        public Builder addReplicas(Collection<PiPreReplica> replicas) {
            Preconditions.checkNotNull(replicas);
            this.replicaSetBuilder.addAll(replicas);
            return this;
        }

        public PiMulticastGroupEntry build() {
            Preconditions.checkNotNull((Object)this.groupId, (Object)"Multicast group ID must be set");
            ImmutableSet replicas = this.replicaSetBuilder.build();
            return new PiMulticastGroupEntry(this.groupId, (Set<PiPreReplica>)replicas);
        }
    }
}

