/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour;

import com.google.common.collect.Lists;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.behaviour.DefaultBridgeDescription;

public class DefaultBridgeDescriptionTest {
    private final BridgeDescription.Builder build = DefaultBridgeDescription.builder();
    private final String name = "expected";
    private final IpAddress ip = IpAddress.valueOf((String)"0.0.0.0");
    private final IpAddress ip2 = IpAddress.valueOf((String)"0.0.0.1");
    private final IpAddress ip3 = IpAddress.valueOf((String)"0.0.0.2");
    private final ControllerInfo controller1 = new ControllerInfo(this.ip, 6653, "test");
    private final ControllerInfo controller2 = new ControllerInfo(this.ip2, 6654, "test");
    private final ControllerInfo controller3 = new ControllerInfo(this.ip3, 6655, "test");
    private final List<ControllerInfo> controllers = Lists.newArrayList((Object[])new ControllerInfo[]{this.controller1, this.controller2, this.controller3});
    private final BridgeDescription.FailMode mode = BridgeDescription.FailMode.SECURE;
    private final String id = "foo";
    private final String type = "bar";

    @Test
    public void testGet() {
        this.build.name("expected");
        this.build.controllers(this.controllers);
        this.build.datapathId("foo");
        this.build.datapathType("bar");
        this.build.failMode(this.mode);
        this.build.disableInBand();
        this.build.mcastSnoopingEnable();
        this.build.enableLocalController();
        BridgeDescription test = this.build.build();
        Assert.assertThat((Object)test.name(), (Matcher)Matchers.is((Object)"expected"));
        Assert.assertThat((Object)test.controllers(), (Matcher)Matchers.is(this.controllers));
        Assert.assertThat((Object)((String)test.datapathId().get()), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)((String)test.datapathType().get()), (Matcher)Matchers.is((Object)"bar"));
        Assert.assertThat((Object)((BridgeDescription.FailMode)test.failMode().get()), (Matcher)Matchers.is((Object)this.mode));
        Assert.assertThat((Object)((Boolean)test.disableInBand().get()), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)((Boolean)test.mcastSnoopingEnable().get()), (Matcher)Matchers.is((Object)true));
        Assert.assertNull((Object)test.annotations());
        Assert.assertTrue((boolean)test.enableLocalController());
        Assert.assertThat((Object)((DeviceId)test.deviceId().get()), (Matcher)Matchers.is((Object)DeviceId.deviceId((String)"of:foo")));
    }
}

