/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.onlab.graph.Edge;
import org.onlab.graph.ScalarWeight;
import org.onlab.graph.Weight;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.IndexTableId;
import org.onosproject.net.flow.TableId;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.PathServiceAdapter;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.store.Timestamp;

public class IntentTestsMocks {
    private static final MockSelector SELECTOR = new MockSelector();
    private static final MockTreatment TREATMENT = new MockTreatment();

    public static class MockDeviceService
    extends DeviceServiceAdapter {
        public boolean isAvailable(DeviceId deviceId) {
            return true;
        }
    }

    public static class MockTimestamp
    implements Timestamp {
        final int value;

        public MockTimestamp(int value) {
            this.value = value;
        }

        public int compareTo(Timestamp o) {
            if (!(o instanceof MockTimestamp)) {
                return -1;
            }
            MockTimestamp that = (MockTimestamp)o;
            return this.value - that.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MockTimestamp) {
                return this.compareTo((MockTimestamp)obj) == 0;
            }
            return false;
        }
    }

    public static class MockIntent
    extends Intent {
        private static AtomicLong counter = new AtomicLong(0L);
        private final Long number;

        public MockIntent(Long number) {
            super(NetTestTools.APP_ID, null, Collections.emptyList(), 100, null);
            this.number = number;
        }

        public MockIntent(Long number, ApplicationId appId) {
            super(appId, null, Collections.emptyList(), 100, null);
            this.number = number;
        }

        public MockIntent(Long number, Collection<NetworkResource> resources) {
            super(NetTestTools.APP_ID, null, resources, 100, null);
            this.number = number;
        }

        public Long number() {
            return this.number;
        }

        public static Long nextId() {
            return counter.getAndIncrement();
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).toString();
        }
    }

    public static class MockFlowRule
    implements FlowRule {
        static int nextId = 0;
        int priority;
        IndexTableId tableId;
        long timestamp;
        int id;

        public MockFlowRule(int priority) {
            this.priority = priority;
            this.tableId = DEFAULT_TABLE;
            this.timestamp = System.currentTimeMillis();
            this.id = nextId++;
        }

        public FlowId id() {
            return FlowId.valueOf((long)this.id);
        }

        public short appId() {
            return 0;
        }

        public GroupId groupId() {
            return new GroupId(0);
        }

        public int priority() {
            return this.priority;
        }

        public DeviceId deviceId() {
            return NetTestTools.did("1");
        }

        public TrafficSelector selector() {
            return SELECTOR;
        }

        public TrafficTreatment treatment() {
            return TREATMENT;
        }

        public int timeout() {
            return 0;
        }

        public int hardTimeout() {
            return 0;
        }

        public FlowRule.FlowRemoveReason reason() {
            return FlowRule.FlowRemoveReason.NO_REASON;
        }

        public boolean isPermanent() {
            return false;
        }

        public int hashCode() {
            return this.priority;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MockFlowRule other = (MockFlowRule)obj;
            return Objects.equals(this.timestamp, other.timestamp) && this.id == other.id;
        }

        public boolean exactMatch(FlowRule rule) {
            return this.equals(rule);
        }

        public int tableId() {
            return (Integer)this.tableId.id();
        }

        public TableId table() {
            return this.tableId;
        }
    }

    public static class MockLinkService
    extends LinkServiceAdapter {
        final String[][] linksHops;

        public MockLinkService(String[][] linksHops) {
            this.linksHops = linksHops;
        }

        public Set<Link> getLinks() {
            return Arrays.asList(this.linksHops).stream().map(path -> NetTestTools.createPath(path).links()).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        public Set<Link> getLinks(ConnectPoint connectPoint) {
            return this.getLinks().stream().filter(link -> link.src().deviceId().equals((Object)connectPoint.deviceId()) || link.dst().deviceId().equals((Object)connectPoint.deviceId())).collect(Collectors.toSet());
        }
    }

    public static class FixedMP2MPMockPathService
    extends PathServiceAdapter {
        final String[] pathHops;
        public static final String DPID_1 = "of:s1";
        public static final String DPID_2 = "of:s2";
        public static final String DPID_3 = "of:s3";
        public static final String DPID_4 = "of:s4";

        public FixedMP2MPMockPathService(String[] pathHops) {
            this.pathHops = pathHops;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst) {
            ArrayList<Link> links = new ArrayList<Link>();
            HashSet<Path> result = new HashSet<Path>();
            ProviderId providerId = new ProviderId("of", "foo");
            if (src.toString().equals(DPID_1) && dst.toString().equals(DPID_4)) {
                links.add(NetTestTools.linkNoPrefixes(src.toString(), 2, this.pathHops[0], 1));
                links.add(NetTestTools.linkNoPrefixes(this.pathHops[0], 2, dst.toString(), 1));
            } else if (src.toString().equals(DPID_2) && dst.toString().equals(DPID_4)) {
                links.add(NetTestTools.linkNoPrefixes(src.toString(), 2, this.pathHops[0], 3));
                links.add(NetTestTools.linkNoPrefixes(this.pathHops[0], 2, dst.toString(), 1));
            } else if (src.toString().equals(DPID_4) && dst.toString().equals(DPID_1)) {
                links.add(NetTestTools.linkNoPrefixes(src.toString(), 2, this.pathHops[0], 1));
                links.add(NetTestTools.linkNoPrefixes(this.pathHops[0], 2, dst.toString(), 1));
            } else if (src.toString().equals(DPID_4) && dst.toString().equals(DPID_2)) {
                links.add(NetTestTools.linkNoPrefixes(src.toString(), 2, this.pathHops[0], 1));
                links.add(NetTestTools.linkNoPrefixes(this.pathHops[0], 3, dst.toString(), 1));
            } else {
                return result;
            }
            DefaultPath path = new DefaultPath(providerId, links, (Weight)ScalarWeight.toWeight((double)3.0), new Annotations[0]);
            result.add((Path)path);
            return result;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
            Set<Path> paths = this.getPaths(src, dst);
            for (Path path : paths) {
                Link link;
                DefaultTopologyVertex dstVertex;
                DefaultTopologyVertex srcVertex;
                Weight weightValue;
                DeviceId dstDevice;
                DeviceId srcDevice = path.src().elementId() instanceof DeviceId ? path.src().deviceId() : null;
                DeviceId deviceId = dstDevice = path.dst().elementId() instanceof DeviceId ? path.dst().deviceId() : null;
                if (srcDevice == null || dstDevice == null || !(weightValue = weigher.weight((Edge)new DefaultTopologyEdge((TopologyVertex)(srcVertex = new DefaultTopologyVertex(srcDevice)), (TopologyVertex)(dstVertex = new DefaultTopologyVertex(dstDevice)), link = NetTestTools.link(src.toString(), 1, dst.toString(), 1)))).isNegative()) continue;
                return new HashSet<Path>();
            }
            return paths;
        }
    }

    public static class FakeLink
    extends DefaultLink {
        public FakeLink(ConnectPoint src, ConnectPoint dst) {
            super(null, src, dst, Link.Type.DIRECT, Link.State.ACTIVE, new Annotations[0]);
        }
    }

    public static class Mp2MpMockPathService
    extends PathServiceAdapter {
        final String[] pathHops;
        final String[] reversePathHops;

        public Mp2MpMockPathService(String[] pathHops) {
            this.pathHops = pathHops;
            String[] reversed = (String[])pathHops.clone();
            Collections.reverse(Arrays.asList(reversed));
            this.reversePathHops = reversed;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst) {
            HashSet<Path> result = new HashSet<Path>();
            String[] allHops = new String[this.pathHops.length + 2];
            allHops[0] = src.toString();
            allHops[allHops.length - 1] = dst.toString();
            if (this.pathHops.length != 0) {
                System.arraycopy(this.pathHops, 0, allHops, 1, this.pathHops.length);
            }
            result.add(NetTestTools.createPath(allHops));
            return result;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
            Set<Path> paths = this.getPaths(src, dst);
            for (Path path : paths) {
                Link link;
                DefaultTopologyVertex dstVertex;
                DefaultTopologyVertex srcVertex;
                Weight weightValue;
                DeviceId dstDevice;
                DeviceId srcDevice = path.src().elementId() instanceof DeviceId ? path.src().deviceId() : null;
                DeviceId deviceId = dstDevice = path.dst().elementId() instanceof DeviceId ? path.dst().deviceId() : null;
                if (srcDevice == null || dstDevice == null || !(weightValue = weigher.weight((Edge)new DefaultTopologyEdge((TopologyVertex)(srcVertex = new DefaultTopologyVertex(srcDevice)), (TopologyVertex)(dstVertex = new DefaultTopologyVertex(dstDevice)), link = NetTestTools.link(src.toString(), 1, dst.toString(), 1)))).isNegative()) continue;
                return new HashSet<Path>();
            }
            return paths;
        }
    }

    public static class MockMultiplePathService
    extends PathServiceAdapter {
        final String[][] pathsHops;

        public MockMultiplePathService(String[][] pathHops) {
            this.pathsHops = pathHops;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst) {
            HashSet allPaths = new HashSet();
            allPaths.addAll(IntStream.range(0, this.pathsHops.length).filter(i -> src.toString().endsWith(this.pathsHops[i][0]) && dst.toString().endsWith(this.pathsHops[i][this.pathsHops[i].length - 1])).mapToObj(i -> NetTestTools.createPath(src instanceof HostId, dst instanceof HostId, this.pathsHops[i])).collect(Collectors.toSet()));
            int minPathLength = allPaths.stream().mapToInt(o -> o.links().size()).min().orElse(Integer.MAX_VALUE);
            Set<Path> shortestPaths = allPaths.stream().filter(path -> path.links().size() <= minPathLength).collect(Collectors.toSet());
            return shortestPaths;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
            Set<Path> paths = this.getPaths(src, dst);
            for (Path path : paths) {
                Link link;
                DefaultTopologyVertex dstVertex;
                DefaultTopologyVertex srcVertex;
                Weight weightValue;
                DeviceId dstDevice;
                DeviceId srcDevice = path.src().elementId() instanceof DeviceId ? path.src().deviceId() : null;
                DeviceId deviceId = dstDevice = path.dst().elementId() instanceof DeviceId ? path.dst().deviceId() : null;
                if (srcDevice == null || dstDevice == null || !(weightValue = weigher.weight((Edge)new DefaultTopologyEdge((TopologyVertex)(srcVertex = new DefaultTopologyVertex(srcDevice)), (TopologyVertex)(dstVertex = new DefaultTopologyVertex(dstDevice)), link = NetTestTools.link(src.toString(), 1, dst.toString(), 1)))).isNegative()) continue;
                return new HashSet<Path>();
            }
            return paths;
        }
    }

    public static class MockPathService
    extends PathServiceAdapter {
        final String[] pathHops;
        final String[] reversePathHops;

        public MockPathService(String[] pathHops) {
            this.pathHops = pathHops;
            String[] reversed = (String[])pathHops.clone();
            Collections.reverse(Arrays.asList(reversed));
            this.reversePathHops = reversed;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst) {
            HashSet<Path> result = new HashSet<Path>();
            String[] allHops = new String[this.pathHops.length];
            if (src.toString().endsWith(this.pathHops[0])) {
                System.arraycopy(this.pathHops, 0, allHops, 0, this.pathHops.length);
            } else {
                System.arraycopy(this.reversePathHops, 0, allHops, 0, this.pathHops.length);
            }
            result.add(NetTestTools.createPath(src instanceof HostId, dst instanceof HostId, allHops));
            return result;
        }

        @Override
        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeigher weigher) {
            Set<Path> paths = this.getPaths(src, dst);
            for (Path path : paths) {
                Link link;
                DefaultTopologyVertex dstVertex;
                DefaultTopologyVertex srcVertex;
                Weight weightValue;
                DeviceId dstDevice;
                DeviceId srcDevice = path.src().elementId() instanceof DeviceId ? path.src().deviceId() : null;
                DeviceId deviceId = dstDevice = path.dst().elementId() instanceof DeviceId ? path.dst().deviceId() : null;
                if (srcDevice == null || dstDevice == null || !(weightValue = weigher.weight((Edge)new DefaultTopologyEdge((TopologyVertex)(srcVertex = new DefaultTopologyVertex(srcDevice)), (TopologyVertex)(dstVertex = new DefaultTopologyVertex(dstDevice)), link = NetTestTools.link(src.toString(), 1, dst.toString(), 1)))).isNegative()) continue;
                return new HashSet<Path>();
            }
            return paths;
        }
    }

    public static class MockTreatment
    implements TrafficTreatment {
        public List<Instruction> deferred() {
            return Collections.emptyList();
        }

        public List<Instruction> immediate() {
            return Collections.emptyList();
        }

        public List<Instruction> allInstructions() {
            return Collections.emptyList();
        }

        public Instructions.TableTypeTransition tableTransition() {
            return null;
        }

        public boolean clearedDeferred() {
            return false;
        }

        public Instructions.MetadataInstruction writeMetadata() {
            return null;
        }

        public Instructions.StatTriggerInstruction statTrigger() {
            return null;
        }

        public Instructions.MeterInstruction metered() {
            return null;
        }

        public Set<Instructions.MeterInstruction> meters() {
            return Sets.newHashSet();
        }
    }

    public static class MockSelector
    implements TrafficSelector {
        public Set<Criterion> criteria() {
            return new HashSet<Criterion>();
        }

        public Criterion getCriterion(Criterion.Type type) {
            return null;
        }
    }
}

