/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.pi.runtime;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.util.ImmutableByteSequence;
import org.onosproject.net.pi.model.PiData;
import org.onosproject.net.pi.runtime.data.PiBitString;
import org.onosproject.net.pi.runtime.data.PiBool;
import org.onosproject.net.pi.runtime.data.PiEnumString;
import org.onosproject.net.pi.runtime.data.PiErrorString;
import org.onosproject.net.pi.runtime.data.PiHeader;
import org.onosproject.net.pi.runtime.data.PiHeaderStack;
import org.onosproject.net.pi.runtime.data.PiHeaderUnion;
import org.onosproject.net.pi.runtime.data.PiHeaderUnionStack;
import org.onosproject.net.pi.runtime.data.PiStruct;
import org.onosproject.net.pi.runtime.data.PiTuple;

public class PiDataTest {
    private final PiData bitString1 = PiBitString.of((ImmutableByteSequence)ImmutableByteSequence.copyFrom((int)10));
    private final PiData sameAsBitString1 = PiBitString.of((ImmutableByteSequence)ImmutableByteSequence.copyFrom((int)10));
    private final PiData bitString2 = PiBitString.of((ImmutableByteSequence)ImmutableByteSequence.copyFrom((int)20));
    private final PiData bool1 = PiBool.of((Boolean)true);
    private final PiData sameAsBool1 = PiBool.of((Boolean)true);
    private final PiData bool2 = PiBool.of((Boolean)false);
    private final PiData tuple1 = PiTuple.of((List)Lists.newArrayList((Object[])new PiData[]{this.bool1}));
    private final PiData sameAsTuple1 = PiTuple.of((List)Lists.newArrayList((Object[])new PiData[]{this.bool1}));
    private final PiData tuple2 = PiTuple.of((List)Lists.newArrayList((Object[])new PiData[]{this.bitString1}));
    private final PiData struct1 = PiStruct.of((List)Lists.newArrayList((Object[])new PiData[]{this.bool1}));
    private final PiData sameAsStruct1 = PiStruct.of((List)Lists.newArrayList((Object[])new PiData[]{this.bool1}));
    private final PiData struct2 = PiStruct.of((List)Lists.newArrayList((Object[])new PiData[]{this.bitString1}));
    private final PiData header1 = PiHeader.of((Boolean)true, (List)Lists.newArrayList((Object[])new ImmutableByteSequence[]{ImmutableByteSequence.copyFrom((int)10)}));
    private final PiData sameAsHeader1 = PiHeader.of((Boolean)true, (List)Lists.newArrayList((Object[])new ImmutableByteSequence[]{ImmutableByteSequence.copyFrom((int)10)}));
    private final PiData header2 = PiHeader.of((Boolean)true, (List)Lists.newArrayList((Object[])new ImmutableByteSequence[]{ImmutableByteSequence.copyFrom((int)20)}));
    private final PiData headerUnion1 = PiHeaderUnion.of((String)"port", (PiHeader)((PiHeader)this.header1));
    private final PiData sameAsHeaderUnion1 = PiHeaderUnion.of((String)"port", (PiHeader)((PiHeader)this.header1));
    private final PiData headerUnion2 = PiHeaderUnion.of((String)"port", (PiHeader)((PiHeader)this.header2));
    private final PiData inValidHeaderUnion1 = PiHeaderUnion.ofInvalid();
    private final PiData sameAsInvalidHeaderUnion1 = PiHeaderUnion.ofInvalid();
    private final PiData headerStack1 = PiHeaderStack.of((List)Lists.newArrayList((Object[])new PiHeader[]{(PiHeader)this.header1}));
    private final PiData sameAsHeaderStack1 = PiHeaderStack.of((List)Lists.newArrayList((Object[])new PiHeader[]{(PiHeader)this.header1}));
    private final PiData headerStack2 = PiHeaderStack.of((List)Lists.newArrayList((Object[])new PiHeader[]{(PiHeader)this.header2}));
    private final PiData headerUnionStack1 = PiHeaderUnionStack.of((List)Lists.newArrayList((Object[])new PiHeaderUnion[]{(PiHeaderUnion)this.headerUnion1}));
    private final PiData sameAsHeaderUnionStack1 = PiHeaderUnionStack.of((List)Lists.newArrayList((Object[])new PiHeaderUnion[]{(PiHeaderUnion)this.headerUnion1}));
    private final PiData headerUnionStack2 = PiHeaderUnionStack.of((List)Lists.newArrayList((Object[])new PiHeaderUnion[]{(PiHeaderUnion)this.headerUnion2}));
    private final PiData enumString1 = PiEnumString.of((String)"test");
    private final PiData sameAsEnumString1 = PiEnumString.of((String)"test");
    private final PiData enumString2 = PiEnumString.of((String)"test1");
    private final PiData errorString1 = PiErrorString.of((String)"failed");
    private final PiData sameAsErrorString1 = PiErrorString.of((String)"failed");
    private final PiData errorString2 = PiErrorString.of((String)"success");

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PiBitString.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiBool.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiTuple.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiStruct.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiHeader.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiHeaderStack.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiHeaderUnion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiHeaderUnionStack.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiEnumString.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PiErrorString.class);
    }

    @Test
    public void testPiDataType() {
        Assert.assertEquals((Object)this.bitString1.type(), (Object)PiData.Type.BITSTRING);
        Assert.assertEquals((Object)this.bool1.type(), (Object)PiData.Type.BOOL);
        Assert.assertEquals((Object)this.tuple1.type(), (Object)PiData.Type.TUPLE);
        Assert.assertEquals((Object)this.struct1.type(), (Object)PiData.Type.STRUCT);
        Assert.assertEquals((Object)this.header1.type(), (Object)PiData.Type.HEADER);
        Assert.assertEquals((Object)this.headerUnion1.type(), (Object)PiData.Type.HEADERUNION);
        Assert.assertEquals((Object)this.headerStack1.type(), (Object)PiData.Type.HEADERSTACK);
        Assert.assertEquals((Object)this.headerUnionStack1.type(), (Object)PiData.Type.HEADERUNIONSTACK);
        Assert.assertEquals((Object)this.enumString1.type(), (Object)PiData.Type.ENUMSTRING);
        Assert.assertEquals((Object)this.errorString1.type(), (Object)PiData.Type.ERRORSTRING);
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.bitString1, this.sameAsBitString1}).addEqualityGroup(new Object[]{this.bitString2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.bool1, this.sameAsBool1}).addEqualityGroup(new Object[]{this.bool2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.tuple1, this.sameAsTuple1}).addEqualityGroup(new Object[]{this.tuple2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.struct1, this.sameAsStruct1}).addEqualityGroup(new Object[]{this.struct2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.header1, this.sameAsHeader1}).addEqualityGroup(new Object[]{this.header2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.headerUnion1, this.sameAsHeaderUnion1}).addEqualityGroup(new Object[]{this.headerUnion2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.inValidHeaderUnion1, this.sameAsInvalidHeaderUnion1}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.headerStack1, this.sameAsHeaderStack1}).addEqualityGroup(new Object[]{this.headerStack2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.headerUnionStack1, this.sameAsHeaderUnionStack1}).addEqualityGroup(new Object[]{this.headerUnionStack2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.enumString1, this.sameAsEnumString1}).addEqualityGroup(new Object[]{this.enumString2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.errorString1, this.sameAsErrorString1}).addEqualityGroup(new Object[]{this.errorString2}).testEquals();
    }
}

