/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onlab.util.ImmutableByteSequence;

public final class PacketDetectionRule {
    private final Ip4Address ueAddr;
    private final ImmutableByteSequence teid;
    private final Ip4Address tunnelDst;
    private final ImmutableByteSequence sessionId;
    private final Integer ctrId;
    private final Integer farId;
    private final Type type;
    private final Byte qfi;
    private final boolean qfiPush;
    private final boolean qfiMatch;
    private static final int SESSION_ID_BITWIDTH = 96;

    private PacketDetectionRule(ImmutableByteSequence sessionId, Integer ctrId, Integer farId, Ip4Address ueAddr, Byte qfi, ImmutableByteSequence teid, Ip4Address tunnelDst, Type type, boolean qfiPush, boolean qfiMatch) {
        this.ueAddr = ueAddr;
        this.teid = teid;
        this.tunnelDst = tunnelDst;
        this.sessionId = sessionId;
        this.ctrId = ctrId;
        this.farId = farId;
        this.qfi = qfi;
        this.type = type;
        this.qfiPush = qfiPush;
        this.qfiMatch = qfiMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String matchString() {
        if (this.matchesEncapped()) {
            return this.matchQfi() ? String.format("Match(Dst=%s, TEID=%s, QFI=%s)", this.tunnelDest(), this.teid(), this.qfi()) : String.format("Match(Dst=%s, TEID=%s)", this.tunnelDest(), this.teid());
        }
        return String.format("Match(Dst=%s, !GTP)", this.ueAddress());
    }

    public String toString() {
        String actionParams = "";
        if (this.hasActionParameters()) {
            actionParams = this.hasQfi() && !this.matchQfi() ? String.format("SEID=%s, FAR=%d, CtrIdx=%d, QFI=%s", this.sessionId.toString(), this.farId, this.ctrId, this.qfi) : String.format("SEID=%s, FAR=%d, CtrIdx=%d", this.sessionId.toString(), this.farId, this.ctrId);
            actionParams = this.pushQfi() ? String.format("%s, QFI_PUSH", actionParams) : actionParams;
        }
        return String.format("PDR{%s -> LoadParams(%s)}", this.matchString(), actionParams);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PacketDetectionRule that = (PacketDetectionRule)obj;
        return this.type.equals((Object)that.type) && Objects.equals(this.teid, that.teid) && Objects.equals(this.tunnelDst, that.tunnelDst) && Objects.equals(this.ueAddr, that.ueAddr) && Objects.equals(this.ctrId, that.ctrId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.farId, that.farId) && Objects.equals(this.qfi, that.qfi) && Objects.equals(this.qfiPush, that.qfiPush) && Objects.equals(this.qfiMatch, that.qfiMatch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ueAddr, this.teid, this.tunnelDst, this.sessionId, this.ctrId, this.farId, this.qfi, this.type});
    }

    public boolean hasActionParameters() {
        return this.type == Type.MATCH_ENCAPPED || this.type == Type.MATCH_UNENCAPPED;
    }

    public PacketDetectionRule withoutActionParams() {
        if (this.matchesEncapped()) {
            Builder pdrBuilder = PacketDetectionRule.builder().withTeid(this.teid).withTunnelDst(this.tunnelDst);
            if (this.hasQfi() && this.matchQfi()) {
                pdrBuilder.withQfiMatch();
                pdrBuilder.withQfi(this.qfi);
            }
            return pdrBuilder.build();
        }
        return PacketDetectionRule.builder().withUeAddr(this.ueAddr).build();
    }

    public boolean matchesEncapped() {
        return this.type == Type.MATCH_ENCAPPED || this.type == Type.MATCH_ENCAPPED_NO_ACTION;
    }

    public boolean matchesUnencapped() {
        return this.type == Type.MATCH_UNENCAPPED || this.type == Type.MATCH_UNENCAPPED_NO_ACTION;
    }

    public ImmutableByteSequence sessionId() {
        return this.sessionId;
    }

    public Ip4Address ueAddress() {
        return this.ueAddr;
    }

    public ImmutableByteSequence teid() {
        return this.teid;
    }

    public Ip4Address tunnelDest() {
        return this.tunnelDst;
    }

    public int counterId() {
        return this.ctrId;
    }

    public int farId() {
        return this.farId;
    }

    public byte qfi() {
        return this.qfi;
    }

    public boolean pushQfi() {
        return this.qfiPush;
    }

    public boolean matchQfi() {
        return this.qfiMatch;
    }

    public boolean hasQfi() {
        return this.qfi != null;
    }

    public static class Builder {
        private ImmutableByteSequence sessionId = null;
        private Integer ctrId = null;
        private Integer localFarId = null;
        private Integer schedulingPriority = null;
        private Ip4Address ueAddr = null;
        private ImmutableByteSequence teid = null;
        private Ip4Address tunnelDst = null;
        private Byte qfi = null;
        private boolean qfiPush = false;
        private boolean qfiMatch = false;

        public Builder withSessionId(ImmutableByteSequence sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder withSessionId(long sessionId) {
            try {
                this.sessionId = ImmutableByteSequence.copyFrom((long)sessionId).fit(96);
            }
            catch (ImmutableByteSequence.ByteSequenceTrimException byteSequenceTrimException) {
                // empty catch block
            }
            return this;
        }

        public Builder withUeAddr(Ip4Address ueAddr) {
            this.ueAddr = ueAddr;
            return this;
        }

        public Builder withCounterId(int ctrId) {
            this.ctrId = ctrId;
            return this;
        }

        public Builder withLocalFarId(int localFarId) {
            this.localFarId = localFarId;
            return this;
        }

        public Builder withQfi(byte qfi) {
            this.qfi = qfi;
            return this;
        }

        public Builder withQfiPush() {
            this.qfiPush = true;
            return this;
        }

        public Builder withQfiMatch() {
            this.qfiMatch = true;
            return this;
        }

        public Builder withTeid(int teid) {
            this.teid = ImmutableByteSequence.copyFrom((int)teid);
            return this;
        }

        public Builder withTeid(ImmutableByteSequence teid) {
            this.teid = teid;
            return this;
        }

        public Builder withTunnelDst(Ip4Address tunnelDst) {
            this.tunnelDst = tunnelDst;
            return this;
        }

        public Builder withTunnel(ImmutableByteSequence teid, Ip4Address tunnelDst) {
            this.teid = teid;
            this.tunnelDst = tunnelDst;
            return this;
        }

        public Builder withTunnel(ImmutableByteSequence teid, Ip4Address tunnelDst, byte qfi) {
            this.teid = teid;
            this.tunnelDst = tunnelDst;
            this.qfi = qfi;
            return this;
        }

        public PacketDetectionRule build() {
            Preconditions.checkArgument((this.ueAddr != null && this.teid == null && this.tunnelDst == null || this.ueAddr == null && this.teid != null && this.tunnelDst != null ? 1 : 0) != 0, (Object)"Either a UE address or a TEID and Tunnel destination must be provided, but not both.");
            Preconditions.checkArgument((this.sessionId != null && this.ctrId != null && this.localFarId != null || this.sessionId == null && this.ctrId == null && this.localFarId == null ? 1 : 0) != 0, (Object)"PDR action parameters must be provided together or not at all.");
            Preconditions.checkArgument((!this.qfiPush || !this.qfiMatch ? 1 : 0) != 0, (Object)"Either match of push QFI can be true, not both.");
            Preconditions.checkArgument((!this.qfiPush || this.qfi != null ? 1 : 0) != 0, (Object)"A QFI must be provided when pushing QFI to the packet.");
            Preconditions.checkArgument((!this.qfiMatch || this.qfi != null ? 1 : 0) != 0, (Object)"A QFI must be provided when matching QFI on the packet.");
            Type type = this.teid != null ? (this.sessionId != null ? Type.MATCH_ENCAPPED : Type.MATCH_ENCAPPED_NO_ACTION) : (this.sessionId != null ? Type.MATCH_UNENCAPPED : Type.MATCH_UNENCAPPED_NO_ACTION);
            return new PacketDetectionRule(this.sessionId, this.ctrId, this.localFarId, this.ueAddr, this.qfi, this.teid, this.tunnelDst, type, this.qfiPush, this.qfiMatch);
        }
    }

    private static enum Type {
        MATCH_ENCAPPED,
        MATCH_UNENCAPPED,
        MATCH_ENCAPPED_NO_ACTION,
        MATCH_UNENCAPPED_NO_ACTION;

    }
}

