/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.behaviour.upf;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.Ip4Prefix;

public final class UpfInterface {
    private final Ip4Prefix prefix;
    private final Type type;

    private UpfInterface(Ip4Prefix prefix, Type type) {
        this.prefix = prefix;
        this.type = type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        String typeStr = this.type.equals((Object)Type.ACCESS) ? "Access" : (this.type.equals((Object)Type.CORE) ? "Core" : (this.type.equals((Object)Type.DBUF) ? "Dbuf-Receiver" : "UNKNOWN"));
        return String.format("Interface{%s, %s}", typeStr, this.prefix);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpfInterface that = (UpfInterface)obj;
        return this.type.equals((Object)that.type) && this.prefix.equals((Object)that.prefix);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prefix, this.type});
    }

    public static UpfInterface createS1uFrom(Ip4Address address) {
        return UpfInterface.builder().setAccess().setPrefix(Ip4Prefix.valueOf((Ip4Address)address, (int)32)).build();
    }

    public static UpfInterface createUePoolFrom(Ip4Prefix prefix) {
        return UpfInterface.builder().setCore().setPrefix(prefix).build();
    }

    public static UpfInterface createDbufReceiverFrom(Ip4Address address) {
        return UpfInterface.builder().setDbufReceiver().setAddress(address).build();
    }

    public Ip4Prefix prefix() {
        return this.prefix;
    }

    public boolean isAccess() {
        return this.type == Type.ACCESS;
    }

    public boolean isCore() {
        return this.type == Type.CORE;
    }

    public boolean isDbufReceiver() {
        return this.type == Type.DBUF;
    }

    public Ip4Prefix getPrefix() {
        return this.prefix;
    }

    public static class Builder {
        private Ip4Prefix prefix;
        private Type type = Type.UNKNOWN;

        public Builder setPrefix(Ip4Prefix prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setAddress(Ip4Address address) {
            this.prefix = Ip4Prefix.valueOf((Ip4Address)address, (int)32);
            return this;
        }

        public Builder setAccess() {
            this.type = Type.ACCESS;
            return this;
        }

        public Builder setCore() {
            this.type = Type.CORE;
            return this;
        }

        public Builder setDbufReceiver() {
            this.type = Type.DBUF;
            return this;
        }

        public UpfInterface build() {
            Preconditions.checkNotNull((Object)this.prefix);
            return new UpfInterface(this.prefix, this.type);
        }
    }

    public static enum Type {
        UNKNOWN,
        ACCESS,
        CORE,
        DBUF;

    }
}

