/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.aaa;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.aaa.StateMachine;
import org.onosproject.aaa.StateMachineException;

public class StateMachineTest {
    StateMachine stateMachine = null;

    @Before
    public void setUp() {
        System.out.println("Set Up.");
        StateMachine.bitSet.clear();
        this.stateMachine = new StateMachine("session0", null);
    }

    @After
    public void tearDown() {
        System.out.println("Tear Down.");
        StateMachine.bitSet.clear();
        this.stateMachine = null;
    }

    @Test
    public void basic() throws StateMachineException {
        System.out.println("======= BASIC =======.");
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)1L);
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
    }

    @Test
    public void testIdleState() throws StateMachineException {
        System.out.println("======= IDLE STATE TEST =======.");
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
        this.stateMachine.denyAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)1L);
    }

    @Test
    public void testStartedState() throws StateMachineException {
        System.out.println("======= STARTED STATE TEST =======.");
        this.stateMachine.start();
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)1L);
        this.stateMachine.denyAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)1L);
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)1L);
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)1L);
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
    }

    @Test
    public void testPendingStateToAuthorized() throws StateMachineException {
        System.out.println("======= PENDING STATE TEST (AUTHORIZED) =======.");
        this.stateMachine.start();
        this.stateMachine.requestAccess();
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
        this.stateMachine.denyAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
    }

    @Test
    public void testPendingStateToUnauthorized() throws StateMachineException {
        System.out.println("======= PENDING STATE TEST (DENIED) =======.");
        this.stateMachine.start();
        this.stateMachine.requestAccess();
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)2L);
        this.stateMachine.denyAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)4L);
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)4L);
    }

    @Test
    public void testAuthorizedState() throws StateMachineException {
        System.out.println("======= AUTHORIZED STATE TEST =======.");
        this.stateMachine.start();
        this.stateMachine.requestAccess();
        this.stateMachine.authorizeAccess();
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
        this.stateMachine.denyAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)3L);
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
    }

    @Test
    public void testUnauthorizedState() throws StateMachineException {
        System.out.println("======= UNAUTHORIZED STATE TEST =======.");
        this.stateMachine.start();
        this.stateMachine.requestAccess();
        this.stateMachine.denyAccess();
        this.stateMachine.start();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)4L);
        this.stateMachine.requestAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)4L);
        this.stateMachine.authorizeAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)4L);
        this.stateMachine.denyAccess();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)4L);
        this.stateMachine.logoff();
        Assert.assertEquals((long)this.stateMachine.getState(), (long)0L);
    }

    @Test
    public void testIdentifierAvailability() throws StateMachineException {
        System.out.println("======= IDENTIFIER TEST =======.");
        byte identifier = this.stateMachine.getIdentifier();
        System.out.println("State: " + this.stateMachine.getState());
        System.out.println("Identifier: " + Byte.toUnsignedInt(identifier));
        Assert.assertEquals((long)-1L, (long)identifier);
        this.stateMachine.start();
        StateMachine sm247 = null;
        StateMachine sm3 = null;
        for (int i = 1; i <= 255; ++i) {
            StateMachine sm = new StateMachine("session" + i, null);
            sm.start();
            byte id = sm.getIdentifier();
            Assert.assertEquals((long)i, (long)Byte.toUnsignedInt(id));
            if (i == 3) {
                sm3 = sm;
                System.out.println("SM3: " + sm3.toString());
            }
            if (i != 247) continue;
            sm247 = sm;
            System.out.println("SM247: " + sm247.toString());
        }
        sm247.requestAccess();
        sm247.authorizeAccess();
        sm247.logoff();
        sm247 = null;
        sm3.requestAccess();
        sm3.authorizeAccess();
        sm3.logoff();
        sm3 = null;
        StateMachine otherSM3 = new StateMachine("session3b", null);
        otherSM3.start();
        otherSM3.requestAccess();
        byte id3 = otherSM3.getIdentifier();
        Assert.assertEquals((long)3L, (long)Byte.toUnsignedInt(id3));
        StateMachine otherSM247 = new StateMachine("session247b", null);
        otherSM247.start();
        otherSM247.requestAccess();
        byte id247 = otherSM247.getIdentifier();
        Assert.assertEquals((long)247L, (long)Byte.toUnsignedInt(id247));
    }
}

